/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.userdata;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import live.minehub.polarpaper.util.ByteArrayUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

public class WorldUserData {
    private static final byte CURRENT_FEATURES_VERSION = 1;
    private static final byte SCHEMATIC_CENTER_VERSION = 1;

    @Nullable
    public static Vector3i readSchematicOffset(byte[] userData) {
        if (userData.length == 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(userData);
        byte version = bb.get();
        if (version < 1) {
            return null;
        }
        int x = bb.getInt();
        int y = bb.getInt();
        int z = bb.getInt();
        return new Vector3i(x, y, z);
    }

    public static byte[] writeSchematicOffset(Vector3i offset) {
        ByteBuf bb = Unpooled.directBuffer();
        bb.writeByte(1);
        bb.writeInt(offset.x);
        bb.writeInt(offset.y);
        bb.writeInt(offset.z);
        return ByteArrayUtil.outputArray(bb);
    }
}

