/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GotoCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        String worldName = (String)ctx.getArgument("worldname", String.class);
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            return 1;
        }
        Player player = (Player)sender;
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld == null) {
            sender.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' does not exist!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        Bukkit.getGlobalRegionScheduler().execute((Plugin)PolarPaper.getPlugin(), () -> {
            Location spawnPos;
            PolarWorld polarWorld = PolarWorld.fromWorld(bukkitWorld);
            if (polarWorld != null) {
                Config config = Config.readFromConfig(PolarPaper.getPlugin().getConfig(), bukkitWorld);
                spawnPos = config.spawn();
            } else {
                spawnPos = bukkitWorld.getSpawnLocation();
            }
            sender.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Teleporting to '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)bukkitWorld.getName(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"'", (TextColor)NamedTextColor.AQUA)));
            spawnPos.setWorld(bukkitWorld);
            player.teleportAsync(spawnPos);
        });
        return 1;
    }
}

