/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import ca.spottedleaf.concurrentutil.util.Priority;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import live.minehub.polarpaper.BlockSelector;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.PolarWriter;
import live.minehub.polarpaper.source.FilePolarSource;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConvertCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        return ConvertCommand.convert(ctx);
    }

    private static int convert(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            return 1;
        }
        Player player = (Player)sender;
        World bukkitWorld = player.getWorld();
        String worldName = bukkitWorld.getName();
        PolarWorld polarWorld = PolarWorld.fromWorld(bukkitWorld);
        if (polarWorld != null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' is already converted! ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"Use ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"/polar save ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.WHITE)));
            return 1;
        }
        String newWorldName = (String)ctx.getArgument("newworldname", String.class);
        Integer chunkRadius = (Integer)ctx.getArgument("chunkradius", Integer.class);
        World newBukkitWorld = Bukkit.getWorld((String)newWorldName);
        if (newBukkitWorld != null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)newBukkitWorld.getName(), (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' already exists!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        long before = System.nanoTime();
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Loading chunks in '", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"'...", (TextColor)NamedTextColor.GRAY)));
        Chunk playerChunk = player.getChunk();
        int offsetX = playerChunk.getX();
        int offsetZ = playerChunk.getZ();
        ArrayList futures = new ArrayList();
        ServerLevel level = ((CraftWorld)bukkitWorld).getHandle();
        for (int x = -chunkRadius.intValue(); x <= chunkRadius; ++x) {
            for (int z = -chunkRadius.intValue(); z <= chunkRadius; ++z) {
                CompletableFuture future = new CompletableFuture();
                level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(x + offsetX, z + offsetZ, ChunkStatus.FEATURES, true, Priority.LOW, realChunk -> future.complete(null));
                futures.add(future);
            }
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Converting '", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"'...", (TextColor)NamedTextColor.GRAY)));
            Polar.updateConfig(bukkitWorld, newWorldName);
            Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), task -> {
                PolarWorld newPolarWorld = PolarWorld.convert(bukkitWorld, PolarWorldAccess.POLAR_PAPER_FEATURES, BlockSelector.square(offsetX, offsetZ, chunkRadius));
                byte[] polarBytes = PolarWriter.write(newPolarWorld);
                FilePolarSource.defaultFolder(newWorldName).saveBytes(polarBytes);
                int ms = (int)((System.nanoTime() - before) / 1000000L);
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Converted '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"' in ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)ms, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"ms. ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"Use ", (TextColor)NamedTextColor.AQUA))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"/polar load ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.runCommand((String)("/polar load " + newWorldName)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to run")))).decorate(TextDecoration.UNDERLINED))).append((Component)Component.text((String)" to load it now", (TextColor)NamedTextColor.AQUA)));
            });
        });
        return 1;
    }
}

