/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import com.github.luben.zstd.Zstd;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarDataConverter;
import live.minehub.polarpaper.PolarSection;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.util.ByteArrayUtil;
import live.minehub.polarpaper.util.PaletteUtil;
import org.jetbrains.annotations.NotNull;

public class PolarWriter {
    private static final int CHUNK_SECTION_SIZE = 16;

    private PolarWriter() {
    }

    public static byte[] write(@NotNull PolarWorld world) {
        return PolarWriter.write(world, PolarDataConverter.DEFAULT);
    }

    public static byte[] write(@NotNull PolarWorld world, @NotNull PolarDataConverter dataConverter) {
        ByteBuf bb = Unpooled.directBuffer();
        bb.writeByte((int)world.minSection());
        bb.writeByte((int)world.maxSection());
        ByteArrayUtil.writeVarInt(world.userData().length, bb);
        bb.writeBytes(world.userData());
        List<PolarChunk> nonEmptyChunks = world.nonEmptyChunks();
        ByteArrayUtil.writeVarInt(nonEmptyChunks.size(), bb);
        for (PolarChunk chunk : nonEmptyChunks) {
            PolarWriter.writeChunk(bb, chunk, world.maxSection() - world.minSection() + 1);
        }
        byte[] contentBytes = ByteArrayUtil.outputArray(bb);
        ByteBuf finalBB = Unpooled.directBuffer();
        finalBB.writeInt(1349479538);
        finalBB.writeShort(7);
        ByteArrayUtil.writeVarInt(dataConverter.dataVersion(), finalBB);
        finalBB.writeByte(world.compression().ordinal());
        switch (world.compression()) {
            case NONE: {
                ByteArrayUtil.writeVarInt(contentBytes.length, finalBB);
                finalBB.writeBytes(contentBytes);
                break;
            }
            case ZSTD: {
                ByteArrayUtil.writeVarInt(contentBytes.length, finalBB);
                finalBB.writeBytes(Zstd.compress((byte[])contentBytes));
            }
        }
        return ByteArrayUtil.outputArray(finalBB);
    }

    private static void writeChunk(@NotNull ByteBuf bb, @NotNull PolarChunk chunk, int sectionCount) {
        ByteArrayUtil.writeVarInt(chunk.x(), bb);
        ByteArrayUtil.writeVarInt(chunk.z(), bb);
        assert (sectionCount == chunk.sections().length) : "section count and chunk section length mismatch";
        for (PolarSection section : chunk.sections()) {
            PolarWriter.writeSection(bb, section);
        }
        ByteArrayUtil.writeVarInt(chunk.blockEntities().length, bb);
        for (PolarChunk.BlockEntity blockEntity : chunk.blockEntities()) {
            ByteArrayUtil.writeBlockEntity(bb, blockEntity);
        }
        int heightmapBits = 0;
        for (int i = 0; i < 32; ++i) {
            if (chunk.heightmap(i) == null) continue;
            heightmapBits |= 1 << i;
        }
        bb.writeInt(heightmapBits);
        int bitsPerEntry = PaletteUtil.bitsToRepresent(sectionCount * 16);
        for (int i = 0; i < 32; ++i) {
            int[] heightmap = chunk.heightmap(i);
            if (heightmap == null) continue;
            if (heightmap.length == 0) {
                ByteArrayUtil.writeLongArray(new long[0], bb);
                continue;
            }
            ByteArrayUtil.writeLongArray(PaletteUtil.pack(heightmap, bitsPerEntry), bb);
        }
        ByteArrayUtil.writeByteArray(chunk.userData(), bb);
    }

    private static void writeSection(@NotNull ByteBuf bb, @NotNull PolarSection section) {
        bb.writeByte(section.isEmpty() ? 1 : 0);
        if (section.isEmpty()) {
            return;
        }
        String[] blockPalette = section.blockPalette();
        ByteArrayUtil.writeStringArray(blockPalette, bb);
        if (blockPalette.length > 1) {
            long[] blockData = section.blockData();
            ByteArrayUtil.writeLongArray(blockData, bb);
        }
        String[] biomePalette = section.biomePalette();
        ByteArrayUtil.writeStringArray(biomePalette, bb);
        if (biomePalette.length > 1) {
            long[] biomeData = section.biomeData();
            ByteArrayUtil.writeLongArray(biomeData, bb);
        }
        bb.writeByte((int)((byte)section.blockLightContent().ordinal()));
        if (section.blockLightContent() == PolarSection.LightContent.PRESENT) {
            bb.writeBytes(section.blockLight());
        }
        bb.writeByte((int)((byte)section.skyLightContent().ordinal()));
        if (section.skyLightContent() == PolarSection.LightContent.PRESENT) {
            bb.writeBytes(section.skyLight());
        }
    }
}

