/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import live.minehub.polarpaper.PolarEntity;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.event.PolarEntitySpawnEvent;
import live.minehub.polarpaper.userdata.EntityUtil;
import live.minehub.polarpaper.util.ByteArrayUtil;
import live.minehub.polarpaper.util.ExceptionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.persistence.DirtyCraftPersistentDataContainer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PolarWorldAccess {
    public static final PolarWorldAccess NOOP = new PolarWorldAccess(){};
    public static final PolarWorldAccess POLAR_PAPER_FEATURES = new PolarWorldAccess(){
        private static final byte CURRENT_FEATURES_VERSION = 2;
        private static final byte ENTITIES_VERSION = 1;
        private static final byte PERSISTENT_DATA_CONTAINER_VERSION = 2;

        @Override
        public void populateChunkData(@NotNull Chunk chunk, byte @Nullable [] userData) {
            if (userData == null) {
                return;
            }
            World world = chunk.getWorld();
            ByteBuf bb = Unpooled.wrappedBuffer((byte[])userData);
            byte version = bb.readByte();
            List<PolarEntity> entities = EntityUtil.getEntities(bb);
            for (PolarEntity polarEntity : entities) {
                Entity entity = polarEntity.toBukkitEntity(world, polarEntity.getLocation(chunk), true);
                if (entity == null) continue;
                Location spawnLocation = entity.getLocation();
                PolarEntitySpawnEvent event = new PolarEntitySpawnEvent(polarEntity, entity, spawnLocation, false);
                event.callEvent();
                if (event.isCancelled()) continue;
                EntityUtil.spawnEntity(entity, world);
            }
            if (version >= 2) {
                PersistentDataContainer persistentDataContainer = chunk.getPersistentDataContainer();
                try {
                    byte[] bytes = ByteArrayUtil.getByteArray(bb);
                    persistentDataContainer.readFromBytes(bytes);
                }
                catch (IOException e) {
                    PolarPaper.logger().warning("Failed to deserialize persistent data container");
                    ExceptionUtil.log(e);
                }
            }
        }

        @Override
        public void saveChunkData(@NotNull ChunkAccess chunk, @NotNull Set<Map.Entry<BlockPos, BlockEntity>> blockEntities, @NotNull Entity[] entities, @NotNull ByteBuf userData) {
            ArrayList<CompletableFuture<PolarEntity>> entityFutures = new ArrayList<CompletableFuture<PolarEntity>>();
            ArrayList<PolarEntity> polarEntities = new ArrayList<PolarEntity>();
            for (Entity entity : entities) {
                if (entity.getType() == EntityType.PLAYER) continue;
                CompletableFuture<PolarEntity> entityFuture = EntityUtil.entityToPolarEntity(entity);
                entityFutures.add(entityFuture);
            }
            for (CompletableFuture completableFuture : entityFutures) {
                PolarEntity polarEntity = (PolarEntity)completableFuture.join();
                polarEntities.add(polarEntity);
            }
            userData.writeByte(2);
            EntityUtil.writeEntities(polarEntities, userData);
            DirtyCraftPersistentDataContainer persistentDataContainer = chunk.persistentDataContainer;
            try {
                byte[] byArray = persistentDataContainer.serializeToBytes();
                ByteArrayUtil.writeByteArray(byArray, userData);
            }
            catch (IOException iOException) {
                PolarPaper.logger().warning("Failed to deserialize persistent data container");
                ExceptionUtil.log(iOException);
            }
        }
    };

    default public void loadChunkData(@NotNull ChunkGenerator.ChunkData chunkData, byte @Nullable [] userData) {
    }

    default public void populateChunkData(@NotNull Chunk chunk, byte @Nullable [] userData) {
    }

    default public void saveChunkData(@NotNull ChunkAccess chunk, @NotNull Set<Map.Entry<BlockPos, BlockEntity>> blockEntities, @NotNull Entity[] entities, @NotNull ByteBuf userData) {
    }

    @ApiStatus.Experimental
    default public void loadHeightmaps(@NotNull ChunkGenerator.ChunkData chunkData, int[][] heightmaps) {
    }

    @ApiStatus.Experimental
    default public void saveHeightmaps(@NotNull ChunkAccess chunk, int[][] heightmaps) {
    }
}

