/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import live.minehub.polarpaper.BlockSelector;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.util.CoordConversion;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolarWorld {
    public static final int MAGIC_NUMBER = 1349479538;
    public static final short LATEST_VERSION = 7;
    public static final short MIN_VERSION = 4;
    static final short VERSION_WORLD_USERDATA = 4;
    static final short VERSION_SHORT_GRASS = 5;
    static final short VERSION_DATA_CONVERTER = 6;
    static final short VERSION_IMPROVED_LIGHT = 7;
    static final short VERSION_DEPRECATED_ENTITIES = 8;
    public static CompressionType DEFAULT_COMPRESSION = CompressionType.ZSTD;
    private final short version;
    private final int dataVersion;
    private CompressionType compression;
    private final byte minSection;
    private final byte maxSection;
    private byte @NotNull [] userData;
    private final Map<Long, PolarChunk> chunks = new ConcurrentHashMap<Long, PolarChunk>();

    public PolarWorld(byte minSection, byte maxSection) {
        this(7, Bukkit.getUnsafe().getDataVersion(), DEFAULT_COMPRESSION, minSection, maxSection, new byte[0], List.of());
    }

    public PolarWorld(short version, int dataVersion, @NotNull CompressionType compression, byte minSection, byte maxSection, byte @NotNull [] userData, @NotNull List<PolarChunk> chunks) {
        this.version = version;
        this.dataVersion = dataVersion;
        this.compression = compression;
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.userData = userData;
        for (PolarChunk chunk : chunks) {
            long index = CoordConversion.chunkIndex(chunk.x(), chunk.z());
            this.chunks.put(index, chunk);
        }
    }

    public short version() {
        return this.version;
    }

    public int dataVersion() {
        return this.dataVersion;
    }

    @NotNull
    public CompressionType compression() {
        return this.compression;
    }

    public void compression(@NotNull CompressionType compression) {
        this.compression = compression;
    }

    public byte minSection() {
        return this.minSection;
    }

    public byte maxSection() {
        return this.maxSection;
    }

    public byte @NotNull [] userData() {
        return this.userData;
    }

    public void userData(byte @NotNull [] userData) {
        this.userData = userData;
    }

    public boolean hasChunkAt(int x, int z) {
        return this.chunks.containsKey(CoordConversion.chunkIndex(x, z));
    }

    @Nullable
    public PolarChunk chunkAt(int x, int z) {
        return this.chunks.getOrDefault(CoordConversion.chunkIndex(x, z), null);
    }

    public void removeChunkAt(int x, int z) {
        this.chunks.remove(CoordConversion.chunkIndex(x, z));
    }

    public void updateChunkAt(int x, int z, @NotNull PolarChunk chunk) {
        this.chunks.put(CoordConversion.chunkIndex(x, z), chunk);
    }

    @NotNull
    public Collection<PolarChunk> chunks() {
        return this.chunks.values();
    }

    @NotNull
    public List<PolarChunk> nonEmptyChunks() {
        ArrayList<PolarChunk> nonEmptyChunks = new ArrayList<PolarChunk>();
        for (PolarChunk chunk : this.chunks()) {
            if (chunk.isEmpty()) continue;
            nonEmptyChunks.add(chunk);
        }
        return nonEmptyChunks;
    }

    @Nullable
    public static PolarWorld fromWorld(World world) {
        if (world == null) {
            return null;
        }
        ChunkGenerator generator = world.getGenerator();
        if (!(generator instanceof PolarGenerator)) {
            return null;
        }
        PolarGenerator polarGenerator = (PolarGenerator)generator;
        return polarGenerator.getPolarWorld();
    }

    public PolarWorld updateChunks(World world) {
        return this.updateChunks(world, PolarWorldAccess.POLAR_PAPER_FEATURES, BlockSelector.ALL);
    }

    public PolarWorld updateChunks(World world, PolarWorldAccess polarWorldAccess, BlockSelector blockSelector) {
        return PolarWorld.convert(world, polarWorldAccess, blockSelector, this.nonEmptyChunks());
    }

    public static PolarWorld convert(World world, PolarWorldAccess polarWorldAccess, BlockSelector blockSelector) {
        return PolarWorld.convert(world, polarWorldAccess, blockSelector, List.of());
    }

    public static PolarWorld convert(World world, PolarWorldAccess polarWorldAccess, BlockSelector blockSelector, Collection<PolarChunk> includedChunks) {
        int minHeight = world.getMinHeight();
        int maxHeight = world.getMaxHeight() - 1;
        PolarWorld newPolarWorld = new PolarWorld((byte)CoordConversion.sectionIndex(minHeight), (byte)CoordConversion.sectionIndex(maxHeight));
        ServerLevel chunkSystemServerLevel = ((CraftWorld)world).getHandle();
        ChunkHolderManager chunkHolderManager = chunkSystemServerLevel.moonrise$getChunkTaskScheduler().chunkHolderManager;
        for (PolarChunk chunk : includedChunks) {
            if (!blockSelector.testChunk(chunk.x(), chunk.z())) continue;
            newPolarWorld.updateChunkAt(chunk.x(), chunk.z(), chunk);
        }
        for (NewChunkHolder chunkHolder : chunkHolderManager.getChunkHolders()) {
            ChunkAccess currentChunk;
            int chunkZ;
            int chunkX;
            if (chunkHolder == null || !blockSelector.testChunk(chunkX = chunkHolder.chunkX, chunkZ = chunkHolder.chunkZ) || (currentChunk = chunkHolder.getCurrentChunk()) == null || currentChunk.getPersistedStatus().isBefore(ChunkStatus.FULL)) continue;
            ChunkEntitySlices entityChunk = chunkHolder.getEntityChunk();
            boolean onlyPlayers = true;
            if (entityChunk != null) {
                for (Entity nmsEntity : entityChunk.getAllEntities()) {
                    CraftEntity entity = nmsEntity.getBukkitEntity();
                    if (entity.getType() == EntityType.PLAYER) continue;
                    onlyPlayers = false;
                    break;
                }
            }
            if (onlyPlayers) {
                boolean allEmpty = true;
                for (LevelChunkSection section : currentChunk.getSections()) {
                    if (section.hasOnlyAir()) continue;
                    allEmpty = false;
                    break;
                }
                if (allEmpty) {
                    newPolarWorld.removeChunkAt(chunkX, chunkZ);
                    continue;
                }
            }
            PolarChunk polarChunk = PolarChunk.convert(chunkHolder, polarWorldAccess, blockSelector);
            newPolarWorld.updateChunkAt(chunkX, chunkZ, polarChunk);
        }
        return newPolarWorld;
    }

    public static enum CompressionType {
        NONE,
        ZSTD;

        private static final CompressionType[] VALUES;

        @Nullable
        public static CompressionType fromId(int id) {
            if (id < 0 || id >= VALUES.length) {
                return null;
            }
            return VALUES[id];
        }

        static {
            VALUES = CompressionType.values();
        }
    }
}

