/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import io.papermc.paper.persistence.PersistentDataContainerView;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.commands.WandCommand;
import live.minehub.polarpaper.schematic.Schematic;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class PolarListener
implements Listener {
    @EventHandler
    public void onChunkPopulate(ChunkPopulateEvent event) {
        PolarWorld polarWorld = PolarWorld.fromWorld(event.getWorld());
        if (polarWorld == null) {
            return;
        }
        ChunkGenerator generator = event.getWorld().getGenerator();
        if (!(generator instanceof PolarGenerator)) {
            return;
        }
        PolarGenerator polarGenerator = (PolarGenerator)generator;
        PolarChunk chunk = polarWorld.chunkAt(event.getChunk().getX(), event.getChunk().getZ());
        if (chunk == null) {
            return;
        }
        if (polarGenerator.getConfig().removeChunks()) {
            polarWorld.removeChunkAt(event.getChunk().getX(), event.getChunk().getZ());
        }
        CraftChunk craftChunk = (CraftChunk)event.getChunk();
        boolean wasUnsaved = craftChunk.getHandle(ChunkStatus.FULL).tryMarkSaved();
        PolarWorldAccess worldAccess = polarGenerator.getWorldAccess();
        if (chunk.userData().length > 0) {
            worldAccess.populateChunkData(event.getChunk(), chunk.userData());
        }
    }

    @EventHandler
    public void onBlockFade(BlockFadeEvent event) {
        PolarGenerator generator = PolarGenerator.fromWorld(event.getBlock().getWorld());
        if (generator == null) {
            return;
        }
        Config config = generator.getConfig();
        Object enabled = config.gamerules().getOrDefault("coralDeath", true);
        if (!(enabled instanceof Boolean)) {
            return;
        }
        Boolean enabledBool = (Boolean)enabled;
        event.setCancelled(enabledBool == false);
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        PolarGenerator generator = PolarGenerator.fromWorld(event.getBlock().getWorld());
        if (generator == null) {
            return;
        }
        Config config = generator.getConfig();
        Object enabled = config.gamerules().getOrDefault("liquidPhysics", true);
        if (!(enabled instanceof Boolean)) {
            return;
        }
        Boolean enabledBool = (Boolean)enabled;
        event.setCancelled(enabledBool == false);
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        PolarGenerator generator = PolarGenerator.fromWorld(event.getBlock().getWorld());
        if (generator == null) {
            return;
        }
        Config config = generator.getConfig();
        Object enabled = config.gamerules().getOrDefault("blockPhysics", true);
        if (!(enabled instanceof Boolean)) {
            return;
        }
        Boolean enabledBool = (Boolean)enabled;
        event.setCancelled(enabledBool == false);
    }

    @EventHandler
    public void onChangeBlock(EntityChangeBlockEvent event) {
        if (!event.getBlock().getType().hasGravity()) {
            return;
        }
        PolarGenerator generator = PolarGenerator.fromWorld(event.getBlock().getWorld());
        if (generator == null) {
            return;
        }
        Config config = generator.getConfig();
        Object enabled = config.gamerules().getOrDefault("blockGravity", true);
        if (!(enabled instanceof Boolean)) {
            return;
        }
        Boolean enabledBool = (Boolean)enabled;
        event.setCancelled(enabledBool == false);
    }

    @EventHandler
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        PersistentDataContainer data = event.getPlayer().getPersistentDataContainer();
        data.remove(Schematic.POS_1_KEY);
        data.remove(Schematic.POS_2_KEY);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        PersistentDataContainer data = event.getPlayer().getPersistentDataContainer();
        data.remove(Schematic.POS_1_KEY);
        data.remove(Schematic.POS_2_KEY);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        PersistentDataContainerView itemData = item.getPersistentDataContainer();
        if (!itemData.has(WandCommand.ITEM_STACK_KEY)) {
            return;
        }
        PersistentDataContainer data = player.getPersistentDataContainer();
        Vector blockPos = event.getBlock().getLocation().toVector();
        int[] array = new int[]{blockPos.getBlockX(), blockPos.getBlockY(), blockPos.getBlockZ()};
        data.set(Schematic.POS_1_KEY, PersistentDataType.INTEGER_ARRAY, (Object)array);
        event.setCancelled(true);
        String formattedPos = String.format("%s, %s, %s", blockPos.getBlockX(), blockPos.getBlockY(), blockPos.getBlockZ());
        player.sendMessage((Component)Component.text((String)("Set first corner position to " + formattedPos), (TextColor)NamedTextColor.AQUA));
    }

    @EventHandler
    public void onBlockBreak(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        PersistentDataContainerView itemData = item.getPersistentDataContainer();
        if (!itemData.has(WandCommand.ITEM_STACK_KEY)) {
            return;
        }
        PersistentDataContainer data = player.getPersistentDataContainer();
        Vector blockPos = event.getClickedBlock().getLocation().toVector();
        int[] array = new int[]{blockPos.getBlockX(), blockPos.getBlockY(), blockPos.getBlockZ()};
        data.set(Schematic.POS_2_KEY, PersistentDataType.INTEGER_ARRAY, (Object)array);
        event.setCancelled(true);
        String formattedPos = String.format("%s, %s, %s", blockPos.getBlockX(), blockPos.getBlockY(), blockPos.getBlockZ());
        player.sendMessage((Component)Component.text((String)("Set second corner position to " + formattedPos), (TextColor)NamedTextColor.AQUA));
    }
}

