/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.fast_palette.FastPaletteData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import live.minehub.polarpaper.BlockSelector;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarSection;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.util.ByteArrayUtil;
import live.minehub.polarpaper.util.CoordConversion;
import live.minehub.polarpaper.util.PaletteUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.BitStorage;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public record PolarChunk(int x, int z, PolarSection[] sections, BlockEntity[] blockEntities, int[][] heightmaps, byte[] userData) {
    public static final int HEIGHTMAP_NONE = 0;
    public static final int HEIGHTMAP_MOTION_BLOCKING = 1;
    public static final int HEIGHTMAP_MOTION_BLOCKING_NO_LEAVES = 2;
    public static final int HEIGHTMAP_OCEAN_FLOOR = 4;
    public static final int HEIGHTMAP_OCEAN_FLOOR_WG = 8;
    public static final int HEIGHTMAP_WORLD_SURFACE = 16;
    public static final int HEIGHTMAP_WORLD_SURFACE_WG = 32;
    static final int[] HEIGHTMAPS = new int[]{0, 1, 2, 4, 8, 16, 32};
    static final int HEIGHTMAP_SIZE = 256;
    static final int MAX_HEIGHTMAPS = 32;

    public PolarChunk(int x, int z, int sectionCount) {
        this(x, z, new PolarSection[sectionCount], new BlockEntity[0], new int[32][0], new byte[0]);
        Arrays.setAll(this.sections, i -> new PolarSection());
    }

    public int @Nullable [] heightmap(int type) {
        return this.heightmaps[type];
    }

    public boolean isEmpty() {
        for (PolarSection section : this.sections) {
            if (section.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public PolarChunk withUserData(byte[] newUserData) {
        return new PolarChunk(this.x, this.z, this.sections, this.blockEntities, this.heightmaps, newUserData);
    }

    public static PolarChunk convert(World world, int chunkX, int chunkZ, PolarWorldAccess worldAccess, BlockSelector blockSelector) {
        ServerLevel chunkSystemServerLevel = ((CraftWorld)world).getHandle();
        ChunkHolderManager chunkHolderManager = chunkSystemServerLevel.moonrise$getChunkTaskScheduler().chunkHolderManager;
        return PolarChunk.convert(chunkHolderManager.getChunkHolder(chunkX, chunkZ), worldAccess, blockSelector);
    }

    public static PolarChunk convert(NewChunkHolder chunkHolder, PolarWorldAccess worldAccess, BlockSelector blockSelector) {
        ChunkAccess chunkAccess = chunkHolder.getCurrentChunk();
        ChunkEntitySlices entityChunk = chunkHolder.getEntityChunk();
        int chunkX = chunkHolder.chunkX;
        int chunkZ = chunkHolder.chunkZ;
        Registry biomeRegistry = MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.BIOME);
        int sectionCount = chunkAccess.getSectionsCount();
        int minSection = chunkAccess.getMinSectionY();
        PolarSection[] sections = new PolarSection[sectionCount];
        for (int i = 0; i < sectionCount; ++i) {
            LevelChunkSection chunkAccessSection = chunkAccess.getSection(i);
            sections[i] = PolarChunk.convertSection(chunkX, chunkZ, chunkAccessSection, (Registry<Biome>)biomeRegistry, blockSelector, minSection, i);
        }
        RegistryAccess.Frozen registryAccess = ((CraftServer)Bukkit.getServer()).getServer().registryAccess();
        Set<Map.Entry<BlockPos, net.minecraft.world.level.block.entity.BlockEntity>> blockEntities = chunkAccess.blockEntities.entrySet();
        ArrayList<BlockEntity> polarBlockEntities = new ArrayList<BlockEntity>();
        for (Map.Entry entry : blockEntities) {
            BlockPos blockPos = (BlockPos)entry.getKey();
            net.minecraft.world.level.block.entity.BlockEntity blockEntity = (net.minecraft.world.level.block.entity.BlockEntity)entry.getValue();
            if (blockPos == null || blockEntity == null || !blockSelector.test(blockPos.getX(), blockPos.getY(), blockPos.getZ())) continue;
            CompoundTag compoundTag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)registryAccess);
            Optional id = compoundTag.getString("id");
            if (id.isEmpty()) {
                PolarPaper.logger().warning("No ID in block entity data at: " + String.valueOf(blockPos));
                PolarPaper.logger().warning("Compound tag: " + String.valueOf(compoundTag));
                continue;
            }
            int index = CoordConversion.chunkBlockIndex(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            polarBlockEntities.add(new BlockEntity(index, (String)id.get(), compoundTag));
        }
        int[][] heightMaps = new int[32][0];
        worldAccess.saveHeightmaps(chunkAccess, heightMaps);
        ByteBuf byteBuf = Unpooled.directBuffer();
        List allEntities = entityChunk == null ? List.of() : entityChunk.getAllEntities();
        ArrayList<CraftEntity> newAllEntities = new ArrayList<CraftEntity>();
        for (net.minecraft.world.entity.Entity ent : allEntities) {
            if (!blockSelector.test(ent.getBlockX(), ent.getBlockY(), ent.getBlockZ())) continue;
            newAllEntities.add(ent.getBukkitEntity());
        }
        Entity[] entitiesArray = newAllEntities.toArray(new Entity[0]);
        worldAccess.saveChunkData(chunkAccess, blockEntities, entitiesArray, byteBuf);
        byte[] userData = ByteArrayUtil.outputArray(byteBuf);
        return new PolarChunk(chunkX, chunkZ, sections, polarBlockEntities.toArray(new BlockEntity[0]), heightMaps, userData);
    }

    private static PolarSection convertSection(int chunkX, int chunkZ, LevelChunkSection chunkAccessSection, Registry<Biome> biomeRegistry, BlockSelector blockSelector, int minSection, int sectionI) {
        Object[] biomePalette;
        Object blockState;
        long[] blockData = null;
        ArrayList<String> blockPaletteStrings = new ArrayList<String>();
        ArrayList<String> biomePaletteStrings = new ArrayList<String>();
        if (!chunkAccessSection.hasOnlyAir()) {
            int airIndex;
            PalettedContainer.Data blockPaletteData = chunkAccessSection.getStates().data;
            Palette chunkPalette = blockPaletteData.palette();
            if (chunkPalette instanceof GlobalPalette) {
                GlobalPalette globalPalette = (GlobalPalette)chunkPalette;
                for (int i1 = 0; i1 < globalPalette.getSize(); ++i1) {
                    BlockState blockState2 = (BlockState)globalPalette.valueFor(i1);
                    blockPaletteStrings.add(blockState2.toString().replace("Block{", "").replace("}", ""));
                }
            } else {
                BlockState palette = chunkPalette.moonrise$getRawPalette((FastPaletteData)blockPaletteData);
                if (palette != null) {
                    for (BlockState p : palette) {
                        if (!(p instanceof BlockState)) continue;
                        blockState = p;
                        blockPaletteStrings.add(blockState.toString().replace("Block{", "").replace("}", ""));
                    }
                }
            }
            if ((airIndex = blockPaletteStrings.indexOf("minecraft:air")) == -1) {
                blockPaletteStrings.add("minecraft:air");
                airIndex = blockPaletteStrings.size() - 1;
            }
            BitStorage blockBitStorage = blockPaletteData.storage().copy();
            for (int index = 0; index < blockBitStorage.getSize(); ++index) {
                boolean included = blockSelector.test(index, chunkX, chunkZ, minSection + sectionI);
                if (included) continue;
                blockBitStorage.set(index, airIndex);
            }
            int bitsPerEntry = (int)Math.ceil(Math.log(blockPaletteStrings.size()) / Math.log(2.0));
            if (4 > bitsPerEntry) {
                int[] ints = new int[blockBitStorage.getSize()];
                PaletteUtil.unpack(ints, blockBitStorage.getRaw(), blockBitStorage.getBits());
                blockData = PaletteUtil.pack(ints, bitsPerEntry);
            } else {
                blockData = blockBitStorage.getRaw();
            }
        } else {
            blockPaletteStrings.add(Blocks.AIR.defaultBlockState().toString().replace("Block{", "").replace("}", ""));
        }
        PalettedContainer.Data biomePaletteData = ((PalettedContainer)chunkAccessSection.getBiomes()).data;
        for (Object p : biomePalette = biomePaletteData.palette().moonrise$getRawPalette((FastPaletteData)biomePaletteData)) {
            Biome biome;
            Identifier key;
            Holder biomeHolder;
            if (p == null || !(p instanceof Holder) || !((blockState = (biomeHolder = (Holder)p).value()) instanceof Biome) || (key = biomeRegistry.getKey((Object)(biome = (Biome)blockState))) == null) continue;
            String biomeString = key.getPath();
            biomePaletteStrings.add(biomeString);
        }
        BitStorage biomeBitStorage = biomePaletteData.storage();
        long[] biomeData = biomeBitStorage.getRaw();
        return new PolarSection(blockPaletteStrings.toArray(new String[0]), blockData, biomePaletteStrings.toArray(new String[0]), biomeData, PolarSection.LightContent.MISSING, null, PolarSection.LightContent.MISSING, null);
    }

    public record BlockEntity(int index, @Nullable String id, @Nullable CompoundTag data) {
    }
}

