/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import io.papermc.paper.world.PaperWorldLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import live.minehub.polarpaper.BlockSelector;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.PolarBiomeProvider;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarReader;
import live.minehub.polarpaper.PolarServerLevel;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.PolarWriter;
import live.minehub.polarpaper.source.FilePolarSource;
import live.minehub.polarpaper.source.PolarSource;
import live.minehub.polarpaper.util.ExceptionUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.Main;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.craftbukkit.CraftGameRule;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.generator.CraftWorldInfo;
import org.bukkit.entity.Player;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Polar {
    private static final Map<String, ScheduledTask> AUTOSAVE_TASK_MAP = new HashMap<String, ScheduledTask>();

    private Polar() {
    }

    public static CompletableFuture<@Nullable World> loadWorldFromFile(@NotNull String worldName) {
        return Polar.loadWorld(FilePolarSource.defaultFolder(worldName), worldName, PolarWorldAccess.POLAR_PAPER_FEATURES);
    }

    public static CompletableFuture<@Nullable World> loadWorld(@NotNull PolarSource source, @NotNull String worldName) {
        return Polar.loadWorld(source, worldName, PolarWorldAccess.POLAR_PAPER_FEATURES);
    }

    public static CompletableFuture<@Nullable World> loadWorld(@NotNull PolarSource source, @NotNull String worldName, @NotNull PolarWorldAccess worldAccess) {
        FileConfiguration fileConfig = PolarPaper.getPlugin().getConfig();
        Config config = Config.readFromConfig(fileConfig, worldName);
        return Polar.loadWorld(source, worldName, config, PolarWorldAccess.POLAR_PAPER_FEATURES);
    }

    public static CompletableFuture<@Nullable World> loadWorld(@NotNull PolarSource source, @NotNull String worldName, @NotNull Config config, @NotNull PolarWorldAccess worldAccess) {
        CompletableFuture<@Nullable World> future = new CompletableFuture<World>();
        Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), task -> {
            try {
                byte[] bytes = source.readBytes();
                PolarWorld polarWorld = PolarReader.read(bytes);
                if (polarWorld.version() == 8) {
                    PolarPaper.logger().info("Re-saving world to update legacy entities");
                    byte[] worldBytes = PolarWriter.write(polarWorld);
                    source.saveBytes(worldBytes);
                }
                Bukkit.getGlobalRegionScheduler().execute((Plugin)PolarPaper.getPlugin(), () -> Polar.createWorld(polarWorld, worldName, config, worldAccess).thenAccept(future::complete));
            }
            catch (Exception e) {
                PolarPaper.logger().warning("Exception while loading world: " + worldName);
                ExceptionUtil.log(e);
                future.complete(null);
            }
        });
        return future;
    }

    public static CompletableFuture<@Nullable World> createWorld(@NotNull PolarWorld world, @NotNull String worldName) {
        FileConfiguration fileConfig = PolarPaper.getPlugin().getConfig();
        Config config = Config.readFromConfig(fileConfig, worldName);
        return Polar.createWorld(world, worldName, config, PolarWorldAccess.POLAR_PAPER_FEATURES);
    }

    public static CompletableFuture<@Nullable World> createWorld(@NotNull PolarWorld world, @NotNull String worldName, @NotNull Config config) {
        return Polar.createWorld(world, worldName, config, PolarWorldAccess.POLAR_PAPER_FEATURES);
    }

    public static CompletableFuture<@Nullable World> createWorld(@NotNull PolarWorld world, @NotNull String worldName, @NotNull PolarWorldAccess worldAccess) {
        FileConfiguration fileConfig = PolarPaper.getPlugin().getConfig();
        Config config = Config.readFromConfig(fileConfig, worldName);
        return Polar.createWorld(world, worldName, config, worldAccess);
    }

    public static CompletableFuture<@Nullable World> createWorld(@NotNull PolarWorld world, @NotNull String worldName, @NotNull Config config, @NotNull PolarWorldAccess worldAccess) {
        if (Bukkit.getWorld((String)worldName) != null) {
            PolarPaper.logger().warning("A world with the name '" + worldName + "' already exists, skipping.");
            return CompletableFuture.completedFuture(null);
        }
        PolarGenerator polar = new PolarGenerator(world, worldAccess, config);
        PolarBiomeProvider polarBiomeProvider = new PolarBiomeProvider(world);
        WorldCreator worldCreator = WorldCreator.name((String)worldName).type(config.worldType()).environment(config.environment()).generator((ChunkGenerator)polar).biomeProvider((BiomeProvider)polarBiomeProvider);
        CompletableFuture<@Nullable World> future = new CompletableFuture<World>();
        Runnable worldCreateRunnable = () -> {
            World newWorld = Polar.createWorld(worldCreator, config.difficulty(), config.gamerules(), config.time());
            if (newWorld == null) {
                PolarPaper.logger().warning("An error occurred loading polar world '" + worldName + "', skipping.");
                future.complete(null);
                return;
            }
            Polar.startAutoSaveTask(newWorld, config);
            future.complete(newWorld);
        };
        if (config.async()) {
            Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), t -> worldCreateRunnable.run());
        } else {
            worldCreateRunnable.run();
        }
        return future;
    }

    private static void startAutoSaveTask(World world, Config config) {
        ScheduledTask prevTask = AUTOSAVE_TASK_MAP.get(world.getName());
        if (prevTask != null) {
            prevTask.cancel();
        }
        if (config.autoSaveIntervalTicks() == -1) {
            return;
        }
        ScheduledTask autosaveTask = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)PolarPaper.getPlugin(), t -> {
            long before = System.nanoTime();
            String savingMsg = String.format("Autosaving '%s'...", world.getName());
            PolarPaper.logger().info(savingMsg);
            for (Player plr : Bukkit.getOnlinePlayers()) {
                if (!plr.hasPermission("polar.notifications")) continue;
                plr.sendMessage((Component)Component.text((String)savingMsg, (TextColor)NamedTextColor.AQUA));
            }
            Bukkit.getGlobalRegionScheduler().execute((Plugin)PolarPaper.getPlugin(), () -> Polar.updateConfig(world, world.getName()));
            Polar.saveWorldToFile(world);
            int ms = (int)((System.nanoTime() - before) / 1000000L);
            String savedMsg = String.format("Saved '%s' in %sms", world.getName(), ms);
            PolarPaper.logger().info(savedMsg);
            for (Player plr : Bukkit.getOnlinePlayers()) {
                if (!plr.hasPermission("polar.notifications")) continue;
                plr.sendMessage((Component)Component.text((String)savedMsg, (TextColor)NamedTextColor.AQUA));
            }
        }, (long)config.autoSaveIntervalTicks() * 50L, (long)config.autoSaveIntervalTicks() * 50L, TimeUnit.MILLISECONDS);
        AUTOSAVE_TASK_MAP.put(world.getName(), autosaveTask);
    }

    private static <T> void setGameRule(World world, org.bukkit.GameRule<?> rule, Object value) {
        world.setGameRule(rule, value);
    }

    public static Config updateConfig(World world, String worldName) {
        PolarPaper.getPlugin().reloadConfig();
        FileConfiguration fileConfig = PolarPaper.getPlugin().getConfig();
        Config defaultConfig = Config.getDefaultConfig(fileConfig);
        Config newConfig = Config.updateConfigWithWorld(Config.readFromConfig(fileConfig, worldName, defaultConfig), world);
        Config.writeToConfig(fileConfig, worldName, newConfig);
        return newConfig;
    }

    public static void reloadConfig(World world) {
        PolarPaper.getPlugin().reloadConfig();
        PolarWorld polarWorld = PolarWorld.fromWorld(world);
        if (polarWorld == null) {
            return;
        }
        PolarGenerator generator = PolarGenerator.fromWorld(world);
        if (generator == null) {
            return;
        }
        Config config = Config.readFromConfig(PolarPaper.getPlugin().getConfig(), world);
        generator.setConfig(config);
        world.setDifficulty(Difficulty.valueOf((String)config.difficulty().name()));
        for (Map.Entry<String, Object> gamerule : config.gamerules().entrySet()) {
            NamespacedKey key = NamespacedKey.fromString((String)gamerule.getKey());
            if (key == null) continue;
            org.bukkit.GameRule rule = (org.bukkit.GameRule)Registry.GAME_RULE.get(key);
            if (rule == null) {
                PolarPaper.logger().warning("Invalid gamerule: " + key.asMinimalString());
                continue;
            }
            Polar.setGameRule(world, rule, gamerule.getValue());
        }
        Polar.startAutoSaveTask(world, config);
    }

    public static void saveWorldToFile(World world) {
        Polar.saveWorld(world, FilePolarSource.defaultFolder(world.getName()));
    }

    public static void saveWorld(World world, PolarSource polarSource) {
        PolarWorld polarWorld = PolarWorld.fromWorld(world);
        if (polarWorld == null) {
            return;
        }
        PolarGenerator generator = PolarGenerator.fromWorld(world);
        if (generator == null) {
            return;
        }
        Polar.saveWorld(world, polarWorld, polarSource, generator.getWorldAccess(), BlockSelector.ALL);
    }

    public static void saveWorld(World world, PolarWorld polarWorld, PolarSource polarSource, PolarWorldAccess polarWorldAccess, BlockSelector blockSelector) {
        PolarWorld newPolarWorld = polarWorld.updateChunks(world, polarWorldAccess, blockSelector);
        byte[] worldBytes = PolarWriter.write(newPolarWorld);
        polarSource.saveBytes(worldBytes);
    }

    @Nullable
    private static World createWorld(WorldCreator creator, Difficulty difficulty, Map<String, Object> gamerules, long time) {
        String levelName;
        PrimaryLevelData primaryLevelData;
        LevelStorageSource.LevelStorageAccess levelStorageAccess;
        boolean async;
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        boolean bl = async = !craftServer.isPrimaryThread();
        if (craftServer.getWorld(creator.name()) != null) {
            return null;
        }
        Preconditions.checkState((boolean)craftServer.getServer().getAllLevels().iterator().hasNext(), (Object)"Cannot create additional worlds on STARTUP");
        String name = creator.name();
        ChunkGenerator chunkGenerator = creator.generator();
        BiomeProvider biomeProvider = creator.biomeProvider();
        File folder = new File(craftServer.getWorldContainer(), name);
        World world = craftServer.getWorld(name);
        World worldByKey = craftServer.getWorld(creator.key());
        if (world != null || worldByKey != null) {
            if (world == worldByKey) {
                return world;
            }
            throw new IllegalArgumentException("Cannot create a world with key " + String.valueOf(creator.key()) + " and name " + name + " one (or both) already match a world that exists");
        }
        if (folder.exists()) {
            Preconditions.checkArgument((boolean)folder.isDirectory(), (String)"File (%s) exists and isn't a folder", (Object)name);
        }
        if (chunkGenerator == null) {
            chunkGenerator = craftServer.getGenerator(name);
        }
        if (biomeProvider == null) {
            biomeProvider = craftServer.getBiomeProvider(name);
        }
        ResourceKey actualDimension = switch (creator.environment()) {
            case World.Environment.NORMAL -> LevelStem.OVERWORLD;
            case World.Environment.NETHER -> LevelStem.NETHER;
            case World.Environment.THE_END -> LevelStem.END;
            default -> throw new IllegalArgumentException("Illegal dimension (" + String.valueOf(creator.environment()) + ")");
        };
        try {
            Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
            Path tempFolder = pluginFolder.resolve("temp");
            levelStorageAccess = LevelStorageSource.createDefault((Path)tempFolder).validateAndCreateAccess(name, actualDimension);
        }
        catch (IOException | ContentValidationException ex) {
            throw new RuntimeException(ex);
        }
        boolean hardcore = creator.hardcore();
        WorldLoader.DataLoadContext context = craftServer.getServer().worldLoaderContext;
        RegistryAccess.Frozen registryAccess = context.datapackDimensions();
        net.minecraft.core.Registry contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        Dynamic dataTag = PaperWorldLoader.getLevelData((LevelStorageSource.LevelStorageAccess)levelStorageAccess).dataTag();
        if (dataTag != null) {
            LevelDataAndDimensions levelDataAndDimensions = LevelStorageSource.getLevelDataAndDimensions((Dynamic)dataTag, (WorldDataConfiguration)context.dataConfiguration(), (net.minecraft.core.Registry)contextLevelStemRegistry, (HolderLookup.Provider)context.datapackWorldgen());
            primaryLevelData = (PrimaryLevelData)levelDataAndDimensions.worldData();
            registryAccess = levelDataAndDimensions.dimensions().dimensionsRegistryAccess();
        } else {
            net.minecraft.world.Difficulty minecraftDifficulty;
            WorldOptions worldOptions = new WorldOptions(creator.seed(), creator.generateStructures(), creator.bonusChest());
            try {
                minecraftDifficulty = net.minecraft.world.Difficulty.valueOf((String)difficulty.name());
            }
            catch (IllegalArgumentException e) {
                PolarPaper.logger().warning("Difficulty " + difficulty.name() + " not found, defaulting to NORMAL");
                minecraftDifficulty = net.minecraft.world.Difficulty.NORMAL;
            }
            GameRules nmsGameRules = new GameRules(context.dataConfiguration().enabledFeatures());
            for (Map.Entry<String, Object> entry : gamerules.entrySet()) {
                NamespacedKey key = NamespacedKey.fromString((String)entry.getKey());
                if (key == null) {
                    if (Config.DEFAULT_GAMERULES.containsKey(entry.getKey())) continue;
                    PolarPaper.logger().warning("Invalid gamerule: " + entry.getKey());
                    continue;
                }
                org.bukkit.GameRule rule = (org.bukkit.GameRule)Registry.GAME_RULE.get(key);
                if (rule == null) {
                    PolarPaper.logger().warning("Invalid gamerule: " + key.asMinimalString());
                    continue;
                }
                GameRule nmsRule = (GameRule)((CraftGameRule)rule).getHandle();
                nmsGameRules.set(nmsRule, entry.getValue(), null);
            }
            DedicatedServerProperties.WorldDimensionData properties = new DedicatedServerProperties.WorldDimensionData(GsonHelper.parse((String)(creator.generatorSettings().isEmpty() ? "{}" : creator.generatorSettings())), creator.type().name().toLowerCase(Locale.ROOT));
            LevelSettings levelSettings = new LevelSettings(name, GameType.byId((int)craftServer.getDefaultGameMode().getValue()), hardcore, minecraftDifficulty, false, nmsGameRules, context.dataConfiguration());
            WorldDimensions worldDimensions = properties.create(context.datapackWorldgen());
            WorldDimensions.Complete complete = worldDimensions.bake(contextLevelStemRegistry);
            Lifecycle lifecycle = complete.lifecycle().add(context.datapackWorldgen().allRegistriesLifecycle());
            primaryLevelData = new PrimaryLevelData(levelSettings, worldOptions, complete.specialWorldProperty(), lifecycle);
            registryAccess = complete.dimensionsRegistryAccess();
        }
        primaryLevelData.customDimensions = contextLevelStemRegistry = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        primaryLevelData.checkName(name);
        primaryLevelData.setModdedInfo(craftServer.getServer().getServerModName(), craftServer.getServer().getModdedStatus().shouldReportAsModified());
        if (craftServer.getServer().options.has("forceUpgrade")) {
            Main.forceUpgrade((LevelStorageSource.LevelStorageAccess)levelStorageAccess, (WorldData)primaryLevelData, (DataFixer)DataFixers.getDataFixer(), (boolean)craftServer.getServer().options.has("eraseCache"), () -> true, (RegistryAccess)registryAccess, (boolean)craftServer.getServer().options.has("recreateRegionFiles"));
        }
        long i = BiomeManager.obfuscateSeed((long)primaryLevelData.worldGenOptions().seed());
        ImmutableList list = ImmutableList.of();
        LevelStem customStem = (LevelStem)contextLevelStemRegistry.getValue(actualDimension);
        CraftWorldInfo worldInfo = new CraftWorldInfo(primaryLevelData, levelStorageAccess, creator.environment(), (DimensionType)customStem.type().value(), customStem.generator(), craftServer.getHandle().getServer().registryAccess());
        if (biomeProvider == null && chunkGenerator != null) {
            biomeProvider = chunkGenerator.getDefaultBiomeProvider((WorldInfo)worldInfo);
        }
        ResourceKey dimensionKey = name.equals((levelName = craftServer.getServer().getProperties().levelName) + "_nether") ? Level.NETHER : (name.equals(levelName + "_the_end") ? Level.END : ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)Identifier.fromNamespaceAndPath((String)creator.key().namespace(), (String)creator.key().value())));
        PolarServerLevel serverLevel = new PolarServerLevel((MinecraftServer)craftServer.getServer(), craftServer.getServer().executor, levelStorageAccess, primaryLevelData, (ResourceKey<Level>)dimensionKey, customStem, primaryLevelData.isDebugWorld(), i, (List<CustomSpawner>)(creator.environment() == World.Environment.NORMAL ? list : ImmutableList.of()), true, craftServer.getServer().overworld().getRandomSequences(), creator.environment(), chunkGenerator, biomeProvider);
        serverLevel.setDayTime(time);
        Runnable initRunnable = () -> {
            craftServer.getServer().addLevel(serverLevel);
            craftServer.getServer().initWorld(serverLevel, primaryLevelData, primaryLevelData.worldGenOptions());
            craftServer.getServer().prepareLevel(serverLevel);
        };
        if (async) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)PolarPaper.getPlugin(), initRunnable);
        } else {
            initRunnable.run();
        }
        return serverLevel.getWorld();
    }
}

