/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.userdata;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

public class WorldUserData {
    private static final byte CURRENT_FEATURES_VERSION = 1;
    private static final byte SCHEMATIC_CENTER_VERSION = 1;

    @Nullable
    public static Vector3i readSchematicOffset(byte[] userData) {
        if (userData.length == 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(userData);
        byte version = bb.get();
        if (version < 1) {
            return null;
        }
        int x = bb.getInt();
        int y = bb.getInt();
        int z = bb.getInt();
        return new Vector3i(x, y, z);
    }

    public static byte[] writeSchematicOffset(Vector3i offset) {
        ByteArrayDataOutput bb = ByteStreams.newDataOutput();
        bb.write(1);
        bb.writeInt(offset.x);
        bb.writeInt(offset.y);
        bb.writeInt(offset.z);
        return bb.toByteArray();
    }
}

