/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.schematic;

import org.jetbrains.annotations.Nullable;

public enum Rotation {
    NONE("none", net.minecraft.world.level.block.Rotation.NONE),
    CLOCKWISE_90("90", net.minecraft.world.level.block.Rotation.CLOCKWISE_90),
    CLOCKWISE_180("180", net.minecraft.world.level.block.Rotation.CLOCKWISE_180),
    CLOCKWISE_270("270", net.minecraft.world.level.block.Rotation.COUNTERCLOCKWISE_90);

    private static final Rotation[] ROTATIONS;
    private final String friendlyName;
    private final net.minecraft.world.level.block.Rotation mcRot;

    private Rotation(String friendlyName, net.minecraft.world.level.block.Rotation mcRot) {
        this.friendlyName = friendlyName;
        this.mcRot = mcRot;
    }

    public int toDegrees() {
        return this.ordinal() * 90;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public net.minecraft.world.level.block.Rotation getMcRot() {
        return this.mcRot;
    }

    public Rotation rotate(Rotation rotation) {
        return Rotation.values()[(this.ordinal() + rotation.ordinal()) % 4];
    }

    @Nullable
    public static Rotation fromFriendlyName(String friendlyName) {
        for (Rotation rotation : ROTATIONS) {
            if (!rotation.friendlyName.equals(friendlyName)) continue;
            return rotation;
        }
        return null;
    }

    static {
        ROTATIONS = Rotation.values();
    }
}

