/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.schematic;

import live.minehub.polarpaper.schematic.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public interface BlockModifier {
    public BlockState modify(Vector3i var1, BlockState var2);

    public void modify(Vector3i var1);

    public void modifyEntity(Location var1);

    public static class PosRot
    implements BlockModifier {
        private final Vector3i offset;
        private final Rotation rotation;

        public PosRot(Vector3i offset, Rotation rotation) {
            this.offset = offset;
            this.rotation = rotation;
        }

        public Vector3i getOffset() {
            return this.offset;
        }

        public Rotation getRotation() {
            return this.rotation;
        }

        @Override
        public BlockState modify(Vector3i pos, BlockState blockState) {
            if (this.rotation != Rotation.NONE) {
                blockState = blockState.rotate(this.rotation.getMcRot());
                Vector3d vec = new Vector3d((Vector3ic)pos);
                PosRot.rotatePos(vec, this.rotation);
                pos.x = (int)vec.x;
                pos.y = (int)vec.y;
                pos.z = (int)vec.z;
            }
            pos.add((Vector3ic)this.offset);
            return blockState;
        }

        @Override
        public void modify(Vector3i pos) {
            if (this.rotation != Rotation.NONE) {
                Vector3d vec = new Vector3d((Vector3ic)pos);
                PosRot.rotatePos(vec, this.rotation);
                pos.x = (int)vec.x;
                pos.y = (int)vec.y;
                pos.z = (int)vec.z;
            }
            pos.add((Vector3ic)this.offset);
        }

        @Override
        public void modifyEntity(Location pos) {
            if (this.rotation != Rotation.NONE) {
                Vector3d vec = new Vector3d(pos.x(), pos.y(), pos.z());
                PosRot.rotatePos(vec, this.rotation);
                pos.setX(vec.x);
                pos.setY(vec.y);
                pos.setZ(vec.z);
                pos.setYaw(pos.getYaw() + (float)this.rotation.toDegrees());
                switch (this.rotation) {
                    case CLOCKWISE_90: {
                        pos.add(1.0, 0.0, 0.0);
                        break;
                    }
                    case CLOCKWISE_180: {
                        pos.add(1.0, 0.0, 1.0);
                        break;
                    }
                    case CLOCKWISE_270: {
                        pos.add(0.0, 0.0, 1.0);
                    }
                }
            }
            pos.add((double)this.offset.x(), (double)this.offset.y(), (double)this.offset.z());
        }

        public static void rotatePos(@NotNull Vector3d point, @NotNull Rotation rotation) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    double x = -point.z;
                    double z = point.x;
                    point.x = x;
                    point.z = z;
                    break;
                }
                case CLOCKWISE_180: {
                    double x = -point.x;
                    double z = -point.z;
                    point.x = x;
                    point.z = z;
                    break;
                }
                case CLOCKWISE_270: {
                    double x = point.z;
                    double z = -point.x;
                    point.x = x;
                    point.z = z;
                }
            }
        }
    }
}

