/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class SaveCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        String worldName = (String)ctx.getArgument("worldname", String.class);
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' does not exist!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        PolarWorld polarWorld = PolarWorld.fromWorld(bukkitWorld);
        if (polarWorld == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' is not a polar world!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        PolarGenerator polarGenerator = PolarGenerator.fromWorld(bukkitWorld);
        if (polarGenerator == null) {
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Saving '", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"'...", (TextColor)NamedTextColor.GRAY)));
        long before = System.nanoTime();
        Bukkit.getGlobalRegionScheduler().execute((Plugin)PolarPaper.getPlugin(), () -> Polar.updateConfig(bukkitWorld, bukkitWorld.getName()));
        Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), task -> {
            Polar.saveWorldToFile(bukkitWorld);
            int ms = (int)((System.nanoTime() - before) / 1000000L);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Saved '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"' in ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)ms, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"ms", (TextColor)NamedTextColor.AQUA)));
        });
        return 1;
    }
}

