/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarReader;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.schematic.BlockModifier;
import live.minehub.polarpaper.schematic.Rotation;
import live.minehub.polarpaper.schematic.Schematic;
import live.minehub.polarpaper.util.ExceptionUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PasteCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar paste <world> [rotation] (while in a world)", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        return PasteCommand.paste(ctx, Rotation.NONE, Schematic.IgnoreAir.ALL);
    }

    protected static int runWithRotation(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar paste <world> [rotation] (while in a world)", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        String rotationString = (String)ctx.getArgument("rotation", String.class);
        Rotation rotation = Rotation.fromFriendlyName(rotationString.toLowerCase());
        if (rotation == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)("Invalid rotation '" + rotationString + "'"), (TextColor)NamedTextColor.RED));
            return 1;
        }
        return PasteCommand.paste(ctx, rotation, Schematic.IgnoreAir.ALL);
    }

    protected static int runWithRotationAndAirIgnore(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)Component.text().append((Component)Component.text((String)"Usage: /polar paste <world> [rotation] [air ignore] (while in a world)", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        String rotationString = (String)ctx.getArgument("rotation", String.class);
        Rotation rotation = Rotation.fromFriendlyName(rotationString.toLowerCase());
        if (rotation == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)("Invalid rotation '" + rotationString + "'"), (TextColor)NamedTextColor.RED));
            return 1;
        }
        String ignoreAirString = (String)ctx.getArgument("ignoreair", String.class);
        try {
            Schematic.IgnoreAir ignoreAir = Schematic.IgnoreAir.valueOf(ignoreAirString.toUpperCase());
            return PasteCommand.paste(ctx, rotation, ignoreAir);
        }
        catch (IllegalArgumentException ignored) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)("Invalid air ignore '" + ignoreAirString + "'"), (TextColor)NamedTextColor.RED));
            return 1;
        }
    }

    private static int paste(CommandContext<CommandSourceStack> ctx, Rotation rotation, Schematic.IgnoreAir ignoreAir) {
        PolarWorld polarWorld;
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(commandSender instanceof Player)) {
            return 1;
        }
        Player player = (Player)commandSender;
        long before = System.nanoTime();
        String worldName = (String)ctx.getArgument("worldname", String.class);
        Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path worldsFolder = pluginFolder.resolve("worlds");
        Path path = worldsFolder.resolve(worldName + ".polar");
        if (!Files.exists(path, new LinkOption[0])) {
            player.sendMessage((Component)Component.text((String)("Couldn't find file '" + worldName + ".polar' in the worlds folder"), (TextColor)NamedTextColor.RED));
            return 1;
        }
        try {
            byte[] polarBytes;
            try {
                polarBytes = Files.readAllBytes(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            polarWorld = PolarReader.read(polarBytes);
        }
        catch (Exception e) {
            PolarPaper.logger().warning("Failed to load world '" + worldName + ".polar'");
            player.sendMessage((Component)Component.text((String)("Failed to load world '" + worldName + ".polar'"), (TextColor)NamedTextColor.RED));
            ExceptionUtil.log(e);
            return 1;
        }
        BlockModifier.PosRot modifier = new BlockModifier.PosRot(player.getLocation().toVector().toVector3i(), rotation);
        Schematic.paste(polarWorld, player.getWorld(), modifier, ignoreAir);
        int ms = (int)((System.nanoTime() - before) / 1000000L);
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Pasted '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"' in ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)ms, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"ms", (TextColor)NamedTextColor.AQUA)));
        return 1;
    }
}

