/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import com.github.luben.zstd.Zstd;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarDataConverter;
import live.minehub.polarpaper.PolarEntity;
import live.minehub.polarpaper.PolarSection;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.source.PolarSource;
import live.minehub.polarpaper.userdata.EntityUtil;
import live.minehub.polarpaper.util.ByteArrayUtil;
import live.minehub.polarpaper.util.PaletteUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PolarReader {
    private static final int MAX_BLOCK_PALETTE_SIZE = 4096;
    private static final int MAX_BIOME_PALETTE_SIZE = 512;

    @NotNull
    public static PolarWorld read(PolarSource source) {
        return PolarReader.read(source.readBytes());
    }

    @NotNull
    public static PolarWorld read(PolarSource source, @NotNull PolarDataConverter dataConverter) {
        return PolarReader.read(source.readBytes(), dataConverter);
    }

    @NotNull
    public static PolarWorld read(byte @NotNull [] data) {
        return PolarReader.read(data, PolarDataConverter.DEFAULT);
    }

    @NotNull
    public static PolarWorld read(byte @NotNull [] data, @NotNull PolarDataConverter dataConverter) {
        ByteBuf bb = Unpooled.wrappedBuffer((byte[])data);
        int magic = bb.readInt();
        PolarReader.assertThat(magic == 1349479538, "Invalid magic number");
        short version = bb.readShort();
        PolarReader.validateVersion(version);
        int dataVersion = version >= 6 ? ByteArrayUtil.getVarInt(bb) : dataConverter.defaultDataVersion();
        byte compressionByte = bb.readByte();
        PolarWorld.CompressionType compression = PolarWorld.CompressionType.fromId(compressionByte);
        PolarReader.assertThat(compression != null, "Invalid compression type");
        int compressedDataLength = ByteArrayUtil.getVarInt(bb);
        ByteBuf uncompressed = PolarReader.decompressBuffer(bb, compression, compressedDataLength);
        byte minSection = uncompressed.readByte();
        byte maxSection = uncompressed.readByte();
        PolarReader.assertThat(minSection < maxSection, "Invalid section range");
        byte[] userData = new byte[]{};
        if (version > 4) {
            int userDataLength = ByteArrayUtil.getVarInt(uncompressed);
            byte[] bytes = new byte[userDataLength];
            uncompressed.readBytes(bytes);
            userData = bytes;
        }
        int chunkCount = ByteArrayUtil.getVarInt(uncompressed);
        ArrayList<PolarChunk> chunks = new ArrayList<PolarChunk>(chunkCount);
        for (int i = 0; i < chunkCount; ++i) {
            chunks.add(PolarReader.readChunk(dataConverter, version, dataVersion, uncompressed, maxSection - minSection + 1));
        }
        return new PolarWorld(version, dataVersion, compression, minSection, maxSection, userData, chunks);
    }

    @NotNull
    private static PolarChunk readChunk(@NotNull PolarDataConverter dataConverter, short version, int dataVersion, @NotNull ByteBuf bb, int sectionCount) {
        int chunkX = ByteArrayUtil.getVarInt(bb);
        int chunkZ = ByteArrayUtil.getVarInt(bb);
        PolarSection[] sections = new PolarSection[sectionCount];
        for (int i = 0; i < sectionCount; ++i) {
            sections[i] = PolarReader.readSection(dataConverter, version, dataVersion, bb);
        }
        int blockEntityCount = ByteArrayUtil.getVarInt(bb);
        PolarChunk.BlockEntity[] blockEntities = new PolarChunk.BlockEntity[blockEntityCount];
        for (int i = 0; i < blockEntityCount; ++i) {
            blockEntities[i] = PolarReader.readBlockEntity(dataConverter, version, dataVersion, bb);
        }
        ArrayList<PolarEntity> entities = null;
        if (version == 8) {
            entities = new ArrayList<PolarEntity>();
            int entityCount = ByteArrayUtil.getVarInt(bb);
            for (int i = 0; i < entityCount; ++i) {
                entities.add(new PolarEntity(bb.readDouble(), bb.readDouble(), bb.readDouble(), bb.readFloat(), bb.readFloat(), ByteArrayUtil.getByteArray(bb)));
            }
        }
        int[][] heightmaps = new int[32][];
        int heightmapMask = bb.readInt();
        for (int i = 0; i < 32; ++i) {
            if ((heightmapMask & 1 << i) == 0) continue;
            long[] packed = ByteArrayUtil.getLongArray(bb);
            if (packed.length == 0) {
                heightmaps[i] = new int[0];
                continue;
            }
            int bitsPerEntry = packed.length * 64 / 256;
            heightmaps[i] = new int[256];
            PaletteUtil.unpack(heightmaps[i], packed, bitsPerEntry);
        }
        int userDataLength = ByteArrayUtil.getVarInt(bb);
        byte[] userData = new byte[userDataLength];
        bb.readBytes(userData);
        if (entities != null) {
            ByteArrayDataOutput newData = ByteStreams.newDataOutput();
            newData.writeByte(1);
            EntityUtil.writeEntities(entities, newData);
            userData = newData.toByteArray();
        }
        return new PolarChunk(chunkX, chunkZ, sections, blockEntities, heightmaps, userData);
    }

    @NotNull
    private static PolarSection readSection(@NotNull PolarDataConverter dataConverter, short version, int dataVersion, @NotNull ByteBuf bb) {
        PolarSection.LightContent skyLightContent;
        PolarSection.LightContent blockLightContent;
        if (bb.readByte() == 1) {
            return new PolarSection();
        }
        String[] blockPalette = ByteArrayUtil.getStringList(bb, 4096);
        if (dataVersion < dataConverter.dataVersion()) {
            dataConverter.convertBlockPalette(blockPalette, dataVersion, dataConverter.dataVersion());
        }
        if (version <= 5) {
            for (int i = 0; i < blockPalette.length; ++i) {
                int index;
                String strippedID;
                if (!blockPalette[i].contains("grass") || !(strippedID = blockPalette[i].split("\\[")[0]).substring((index = strippedID.indexOf(58)) + 1).equals("grass")) continue;
                blockPalette[i] = "short_grass";
            }
        }
        int[] blockData = null;
        if (blockPalette.length > 1) {
            blockData = new int[4096];
            long[] rawBlockData = ByteArrayUtil.getLongArray(bb);
            int bitsPerEntry = (int)Math.ceil(Math.log(blockPalette.length) / Math.log(2.0));
            PaletteUtil.unpack(blockData, rawBlockData, bitsPerEntry);
        }
        String[] biomePalette = ByteArrayUtil.getStringList(bb, 512);
        int[] biomeData = null;
        if (biomePalette.length > 1) {
            biomeData = new int[64];
            long[] rawBiomeData = ByteArrayUtil.getLongArray(bb);
            int bitsPerEntry = (int)Math.ceil(Math.log(biomePalette.length) / Math.log(2.0));
            PaletteUtil.unpack(biomeData, rawBiomeData, bitsPerEntry);
        }
        byte[] blockLight = null;
        byte[] skyLight = null;
        PolarSection.LightContent lightContent = version >= 7 ? PolarSection.LightContent.VALUES[bb.readByte()] : (blockLightContent = bb.readByte() == 1 ? PolarSection.LightContent.PRESENT : PolarSection.LightContent.MISSING);
        if (blockLightContent == PolarSection.LightContent.PRESENT) {
            blockLight = ByteArrayUtil.getLightData(bb);
        }
        PolarSection.LightContent lightContent2 = version >= 7 ? PolarSection.LightContent.VALUES[bb.readByte()] : (skyLightContent = bb.readByte() == 1 ? PolarSection.LightContent.PRESENT : PolarSection.LightContent.MISSING);
        if (skyLightContent == PolarSection.LightContent.PRESENT) {
            skyLight = ByteArrayUtil.getLightData(bb);
        }
        return new PolarSection(blockPalette, blockData, biomePalette, biomeData, blockLightContent, blockLight, skyLightContent, skyLight);
    }

    @NotNull
    private static PolarChunk.BlockEntity readBlockEntity(@NotNull PolarDataConverter dataConverter, int version, int dataVersion, @NotNull ByteBuf bb) {
        int posIndex = bb.readInt();
        String id = ByteArrayUtil.getStringOptional(bb);
        ByteBufInputStream bbis = new ByteBufInputStream(bb);
        CompoundTag nbt = new CompoundTag();
        if (bb.readByte() == 1) {
            try {
                nbt = (CompoundTag)NbtIo.readAnyTag((DataInput)bbis, (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (dataVersion < dataConverter.dataVersion()) {
            Map.Entry<String, CompoundTag> converted = dataConverter.convertBlockEntityData(id == null ? "" : id, nbt, dataVersion, dataConverter.dataVersion());
            if ((id = converted.getKey()).isEmpty()) {
                id = null;
            }
            if ((nbt = converted.getValue()).isEmpty()) {
                nbt = null;
            }
        }
        return new PolarChunk.BlockEntity(posIndex, id, nbt);
    }

    private static void validateVersion(int version) {
        String invalidVersionError = String.format("Unsupported Polar version. Versions %d - %d are supported, found %d.", (short)7, (short)4, version);
        PolarReader.assertThat(version <= 7 && version >= 4 || version == 8, invalidVersionError);
    }

    @NotNull
    private static ByteBuf decompressBuffer(@NotNull ByteBuf buffer, @NotNull PolarWorld.CompressionType compression, int compressedLength) {
        return switch (compression) {
            default -> throw new MatchException(null, null);
            case PolarWorld.CompressionType.NONE -> Unpooled.wrappedBuffer((ByteBuf)buffer);
            case PolarWorld.CompressionType.ZSTD -> {
                int limit = buffer.capacity();
                int length = limit - buffer.readerIndex();
                PolarReader.assertThat(length >= 0, "Invalid remaining: " + length);
                byte[] bytes = new byte[length];
                buffer.readBytes(bytes);
                byte[] decompressed = Zstd.decompress((byte[])bytes, (int)compressedLength);
                yield Unpooled.wrappedBuffer((byte[])decompressed);
            }
        };
    }

    @Contract(value="false, _ -> fail")
    private static void assertThat(boolean condition, @NotNull String message) {
        if (!condition) {
            throw new Error(message);
        }
    }
}

