/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.mojang.logging.LogUtils;
import io.papermc.paper.registry.RegistryKey;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public record PolarEntity(double x, double y, double z, float yaw, float pitch, byte[] bytes) {
    @Nullable
    public Entity toBukkitEntity(World world, Location spawnLocation, boolean randomUUID) {
        ProblemReporter.ScopedCollector problemReporter;
        ValueInput tagValueInput;
        net.minecraft.world.entity.Entity nmsEntity;
        CompoundTag compound;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.bytes);
        DataInputStream dataInput = new DataInputStream(inputStream);
        try {
            compound = NbtIo.read((DataInput)dataInput, (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (IOException e) {
            return null;
        }
        Integer dataVersion = compound.getInt("DataVersion").orElse(null);
        if (dataVersion == null) {
            return null;
        }
        compound = PlatformHooks.get().convertNBT(References.ENTITY, MinecraftServer.getServer().fixerUpper, compound, dataVersion.intValue(), Bukkit.getUnsafe().getDataVersion());
        if (randomUUID) {
            compound.remove("UUID");
        }
        ListTag posTag = new ListTag();
        posTag.add((Object)DoubleTag.valueOf((double)spawnLocation.x()));
        posTag.add((Object)DoubleTag.valueOf((double)spawnLocation.y()));
        posTag.add((Object)DoubleTag.valueOf((double)spawnLocation.z()));
        compound.put("Pos", (Tag)posTag);
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.valueOf((float)spawnLocation.getYaw()));
        rotationTag.add((Object)FloatTag.valueOf((float)spawnLocation.getPitch()));
        compound.put("Rotation", (Tag)rotationTag);
        String entityId = compound.getStringOr("id", "").replace("minecraft:", "");
        String paintingVariant = compound.getString("variant").orElse(null);
        if (entityId.equals("painting") && paintingVariant != null) {
            int facingIndex = (int)Math.floor(spawnLocation.getYaw() / 90.0f) % 4;
            Direction[] directions = new Direction[]{Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST};
            compound.put("facing", (Tag)IntTag.valueOf((int)facingIndex));
            Direction paintingDir = directions[facingIndex];
            Direction counterClockWise = paintingDir.getCounterClockWise();
            Vec3i unitVec3i = counterClockWise.getUnitVec3i();
            Art art = (Art)Bukkit.getUnsafe().get(RegistryKey.PAINTING_VARIANT, NamespacedKey.fromString((String)paintingVariant.toLowerCase(Locale.ROOT)));
            if (art != null && art.getBlockHeight() % 2 == 0) {
                spawnLocation.subtract(0.0, 1.0, 0.0);
            }
            if (art != null && art.getBlockWidth() % 2 == 0) {
                spawnLocation.subtract((double)unitVec3i.getX() * 0.5, 0.0, (double)unitVec3i.getZ() * 0.5);
            }
            IntArrayTag blockPosTag = new IntArrayTag(new int[]{spawnLocation.blockX(), spawnLocation.blockY(), spawnLocation.blockZ()});
            compound.put("block_pos", (Tag)blockPosTag);
        }
        Integer facingValue = compound.getInt("Facing").orElse(null);
        if ((entityId.equals("item_frame") || entityId.equals("glow_item_frame")) && facingValue != null && facingValue != 1 && facingValue != 0) {
            int facingIndex = (int)Math.floor(spawnLocation.getYaw() / 90.0f) % 4;
            Direction[] directions = new Direction[]{Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST};
            int newFacingValue = directions[facingIndex].get3DDataValue();
            compound.put("Facing", (Tag)IntTag.valueOf((int)newFacingValue));
            IntArrayTag blockPosTag = new IntArrayTag(new int[]{spawnLocation.blockX(), spawnLocation.blockY(), spawnLocation.blockZ()});
            compound.put("block_pos", (Tag)blockPosTag);
        }
        if ((nmsEntity = (net.minecraft.world.entity.Entity)EntityType.create((ValueInput)(tagValueInput = TagValueInput.create((ProblemReporter)(problemReporter = new ProblemReporter.ScopedCollector(() -> "deserialiseEntity", LogUtils.getLogger())), (HolderLookup.Provider)((CraftWorld)world).getHandle().registryAccess(), (CompoundTag)compound)), (Level)((CraftWorld)world).getHandle(), (EntitySpawnReason)EntitySpawnReason.LOAD).orElse(null)) == null) {
            return null;
        }
        return nmsEntity.getBukkitEntity();
    }

    public Location getLocation(Chunk chunk) {
        return this.getLocation(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public Location getLocation(World world, int chunkX, int chunkZ) {
        double realX = this.x;
        double realZ = this.z;
        if (this.x < 0.0) {
            realX += 16.0;
        }
        if (this.z < 0.0) {
            realZ += 16.0;
        }
        return new Location(world, realX + (double)(chunkX * 16), this.y, realZ + (double)(chunkZ * 16), this.yaw, this.pitch);
    }
}

