/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.userdata;

import com.google.common.io.ByteArrayDataOutput;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import live.minehub.polarpaper.PolarEntity;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.util.ByteArrayUtil;
import live.minehub.polarpaper.util.ExceptionUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    private EntityUtil() {
    }

    public static boolean spawnEntity(Entity entity, World world) {
        boolean spawned;
        ServerLevel level = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandleRaw();
        nmsEntity.setLevel((Level)level);
        boolean bl = spawned = !nmsEntity.valid && nmsEntity.level().addFreshEntity(nmsEntity, CreatureSpawnEvent.SpawnReason.DEFAULT);
        if (spawned) {
            nmsEntity.getIndirectPassengers().forEach(e -> e.level().addFreshEntity(e, CreatureSpawnEvent.SpawnReason.DEFAULT));
        }
        return spawned;
    }

    public static List<PolarEntity> getEntities(ByteBuffer bb) {
        ArrayList<PolarEntity> polarEntities = new ArrayList<PolarEntity>();
        int entityCount = ByteArrayUtil.getVarInt(bb);
        for (int i = 0; i < entityCount; ++i) {
            double x = bb.getDouble();
            double y = bb.getDouble();
            double z = bb.getDouble();
            float yaw = bb.getFloat();
            float pitch = bb.getFloat();
            byte[] bytes = ByteArrayUtil.getByteArray(bb);
            polarEntities.add(new PolarEntity(x, y, z, yaw, pitch, bytes));
        }
        return polarEntities;
    }

    public static void writeEntities(List<PolarEntity> entities, @NotNull ByteArrayDataOutput data) {
        ByteArrayUtil.writeVarInt(entities.size(), data);
        for (PolarEntity entity : entities) {
            data.writeDouble(entity.x());
            data.writeDouble(entity.y());
            data.writeDouble(entity.z());
            data.writeFloat(entity.yaw());
            data.writeFloat(entity.pitch());
            ByteArrayUtil.writeByteArray(entity.bytes(), data);
        }
    }

    public static byte @Nullable [] entityToBytes(Entity entity) {
        boolean successful;
        if (entity.getType() == EntityType.PLAYER) {
            return null;
        }
        if (!entity.isPersistent()) {
            return null;
        }
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(() -> "serialiseEntity@" + String.valueOf(entity.getUniqueId()), LogUtils.getLogger());
        TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)problemReporter, (HolderLookup.Provider)nmsEntity.registryAccess());
        try {
            successful = ((CraftEntity)entity).getHandle().saveAsPassenger((ValueOutput)tagValueOutput, true, false, false);
        }
        catch (Exception e) {
            CompletableFuture successfulFuture = new CompletableFuture();
            Bukkit.getScheduler().runTask((Plugin)PolarPaper.getPlugin(), () -> {
                try {
                    boolean successful2 = ((CraftEntity)entity).getHandle().saveAsPassenger((ValueOutput)tagValueOutput, true, false, false);
                    successfulFuture.complete(successful2);
                }
                catch (Exception e2) {
                    PolarPaper.logger().warning("Failed to serialize entity");
                    ExceptionUtil.log(e2);
                }
            });
            successful = (Boolean)successfulFuture.join();
        }
        CompoundTag compound = tagValueOutput.buildResult();
        Optional id = compound.getString("id");
        if (id.isEmpty() || ((String)id.get()).isBlank() || !successful) {
            return null;
        }
        compound.putInt("DataVersion", Bukkit.getUnsafe().getDataVersion());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outputStream);
        try {
            NbtIo.write((CompoundTag)compound, (DataOutput)dataOutput);
            outputStream.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return outputStream.toByteArray();
    }
}

