/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.logging.Logger;
import java.util.stream.Stream;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarListener;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.commands.PolarCommand;
import live.minehub.polarpaper.util.ExceptionUtil;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class PolarPaper
extends JavaPlugin {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void onEnable() {
        @NotNull LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            @NotNull Commands commands = (Commands)event.registrar();
            PolarCommand.register(commands);
        });
        PolarPaper.registerEvents();
        Path pluginFolder = Path.of(this.getDataFolder().getAbsolutePath(), new String[0]);
        Path worldsFolder = pluginFolder.resolve("worlds");
        worldsFolder.toFile().mkdirs();
        this.saveDefaultConfig();
        try (Stream<Path> files = Files.list(worldsFolder);){
            files.forEach(path -> {
                if (!path.getFileName().toString().endsWith(".polar")) {
                    return;
                }
                String worldName = path.getFileName().toString().split("\\.polar")[0];
                Config config = Config.readFromConfig(this.getConfig(), worldName);
                if (!config.loadOnStartup()) {
                    return;
                }
                this.getLogger().info("Loading polar world: " + worldName);
                Polar.loadWorldFromFile(worldName);
            });
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to load world on startup");
            ExceptionUtil.log(e);
        }
    }

    public void onDisable() {
        Path pluginFolder = Path.of(this.getDataFolder().getAbsolutePath(), new String[0]);
        Path tempFolder = pluginFolder.resolve("temp");
        if (Files.exists(tempFolder, new LinkOption[0])) {
            this.getLogger().info("Clearing temp directory");
            try (Stream<Path> paths = Files.walk(tempFolder, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                this.getLogger().warning("Failed to delete temp directory");
                ExceptionUtil.log(e);
            }
        }
        for (World world : this.getServer().getWorlds()) {
            PolarWorld polarWorld = PolarWorld.fromWorld(world);
            PolarGenerator generator = PolarGenerator.fromWorld(world);
            if (polarWorld == null || generator == null) continue;
            if (!generator.getConfig().saveOnStop()) {
                PolarPaper.logger().info(String.format("Not saving '%s' as it has save on stop disabled", world.getName()));
                continue;
            }
            this.getLogger().info("Saving '" + world.getName() + "'...");
            long before = System.nanoTime();
            Polar.updateConfig(world, world.getName());
            Polar.saveWorldToFile(world);
            int ms = (int)((System.nanoTime() - before) / 1000000L);
            PolarPaper.logger().info(String.format("Saved '%s' in %sms", world.getName(), ms));
        }
    }

    public static PolarPaper getPlugin() {
        return (PolarPaper)PolarPaper.getPlugin(PolarPaper.class);
    }

    public static Logger logger() {
        return PolarPaper.getPlugin().getLogger();
    }

    public static void registerEvents() {
        PolarPaper.getPlugin().getServer().getPluginManager().registerEvents((Listener)new PolarListener(), (Plugin)PolarPaper.getPlugin());
    }
}

