/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.source;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.source.PolarSource;

public record FilePolarSource(Path path) implements PolarSource
{
    @Override
    public byte[] readBytes() {
        try {
            return Files.readAllBytes(this.path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveBytes(byte[] data) {
        try {
            Files.write(this.path, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FilePolarSource defaultFolder(String worldName) {
        Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path worldsFolder = pluginFolder.resolve("worlds");
        Path path = worldsFolder.resolve(worldName + ".polar");
        return new FilePolarSource(path);
    }
}

