/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarGenerator;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class UnloadCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        return UnloadCommand.unload(ctx, false, false);
    }

    protected static int runOverrided(CommandContext<CommandSourceStack> ctx) {
        Boolean override = (Boolean)ctx.getArgument("save", Boolean.class);
        return UnloadCommand.unload(ctx, true, override);
    }

    protected static int unload(CommandContext<CommandSourceStack> ctx, boolean saveOverrided, boolean save) {
        boolean shouldSave;
        String worldName = (String)ctx.getArgument("worldname", String.class);
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        PolarWorld polarWorld = PolarWorld.fromWorld(bukkitWorld);
        if (bukkitWorld == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' already not loaded!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        if (polarWorld == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' is not a polar world!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        PolarGenerator generator = PolarGenerator.fromWorld(bukkitWorld);
        if (generator == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"World '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' is not a polar world!", (TextColor)NamedTextColor.RED)));
            return 1;
        }
        Config config = generator.getConfig();
        if (saveOverrided) {
            shouldSave = save;
        } else {
            boolean bl = shouldSave = config.autoSaveIntervalTicks() != -1;
        }
        if (shouldSave) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Saving '", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"'...", (TextColor)NamedTextColor.GRAY)));
            Polar.updateConfig(bukkitWorld, bukkitWorld.getName());
            Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), task -> {
                Polar.saveWorldToFile(bukkitWorld);
                UnloadCommand.bukkitUnload(ctx, bukkitWorld);
            });
        } else {
            if (saveOverrided) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"Save force disabled, world will not be saved before unload", (TextColor)NamedTextColor.AQUA));
            } else {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"Autosave is disabled, world will not be saved before unload", (TextColor)NamedTextColor.AQUA));
            }
            UnloadCommand.bukkitUnload(ctx, bukkitWorld);
        }
        return 1;
    }

    private static void bukkitUnload(CommandContext<CommandSourceStack> ctx, World bukkitWorld) {
        Bukkit.getScheduler().runTask((Plugin)PolarPaper.getPlugin(), () -> {
            String worldName = bukkitWorld.getName();
            boolean successful = Bukkit.unloadWorld((World)bukkitWorld, (boolean)false);
            if (successful) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Unloaded '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"'", (TextColor)NamedTextColor.AQUA)));
            } else if (!bukkitWorld.getPlayers().isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"There are still players in '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"'", (TextColor)NamedTextColor.RED)));
            } else {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Something went wrong while unloading '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"'", (TextColor)NamedTextColor.RED)));
            }
        });
    }
}

