/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarReader;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.util.ExceptionUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;

public class CopyCommand {
    public static int run(CommandContext<CommandSourceStack> ctx) {
        PolarWorld polarWorld;
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        String worldName = (String)ctx.getArgument("worldname", String.class);
        String newWorldName = (String)ctx.getArgument("newworldname", String.class);
        Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path worldsFolder = pluginFolder.resolve("worlds");
        Path path = worldsFolder.resolve(worldName + ".polar");
        if (!Files.exists(path, new LinkOption[0])) {
            sender.sendMessage((Component)Component.text((String)("Couldn't find file '" + worldName + ".polar' in the worlds folder"), (TextColor)NamedTextColor.RED));
            return 1;
        }
        try {
            byte[] polarBytes;
            try {
                polarBytes = Files.readAllBytes(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            polarWorld = PolarReader.read(polarBytes);
        }
        catch (Exception e) {
            PolarPaper.logger().warning("Failed to load world '" + worldName + ".polar'");
            sender.sendMessage((Component)Component.text((String)("Failed to load world '" + worldName + ".polar'"), (TextColor)NamedTextColor.RED));
            ExceptionUtil.log(e);
            return 1;
        }
        Polar.createWorld(polarWorld, newWorldName);
        sender.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Copied '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"' to '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"'. ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"Use ", (TextColor)NamedTextColor.AQUA))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"/polar goto ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.runCommand((String)("/polar goto " + newWorldName)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to run")))).decorate(TextDecoration.UNDERLINED))).append((Component)Component.text((String)" to teleport now", (TextColor)NamedTextColor.AQUA)));
        return 1;
    }
}

