/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import java.util.Arrays;
import java.util.Random;
import live.minehub.polarpaper.Config;
import live.minehub.polarpaper.PolarChunk;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarSection;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.util.CoordConversion;
import live.minehub.polarpaper.util.PaletteUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.BitStorage;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.generator.CraftChunkData;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolarGenerator
extends ChunkGenerator {
    private final PolarWorld polarWorld;
    private final PolarWorldAccess worldAccess;
    private Config config;

    public PolarGenerator(PolarWorld polarWorld, Config config) {
        this(polarWorld, PolarWorldAccess.POLAR_PAPER_FEATURES, config);
    }

    public PolarGenerator(PolarWorld polarWorld, PolarWorldAccess worldAccess, Config config) {
        this.polarWorld = polarWorld;
        this.worldAccess = worldAccess;
        this.config = config;
    }

    public void generateSurface(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        PolarChunk chunk = this.polarWorld.chunkAt(chunkX, chunkZ);
        if (chunk == null) {
            return;
        }
        ChunkAccess chunkAccess = ((CraftChunkData)chunkData).getHandle();
        int i = 0;
        for (PolarSection section : chunk.sections()) {
            LevelChunkSection chunkAccessSection = chunkAccess.getSection(i++);
            this.loadSection(section, chunkAccess, chunkAccessSection);
        }
        for (PolarChunk.BlockEntity blockEntity : chunk.blockEntities()) {
            this.loadBlockEntity(blockEntity, chunkAccess, chunkX, chunkZ);
        }
        this.worldAccess.loadHeightmaps(chunkData, chunk.heightmaps());
        if (chunk.userData().length > 0) {
            this.worldAccess.loadChunkData(chunkData, chunk.userData());
        }
    }

    private void loadBlockEntity(@NotNull PolarChunk.BlockEntity polarBlockEntity, @NotNull ChunkAccess chunkAccess, int chunkX, int chunkZ) {
        RegistryAccess.Frozen registryAccess;
        BlockState blockState;
        int z;
        int y;
        int x;
        BlockPos blockPos;
        BlockEntity blockEntity;
        CompoundTag compoundTag = polarBlockEntity.data();
        if (compoundTag == null) {
            return;
        }
        if (polarBlockEntity.id() != null) {
            compoundTag.putString("id", polarBlockEntity.id());
        }
        if ((blockEntity = BlockEntity.loadStatic((BlockPos)(blockPos = new BlockPos(chunkX * 16 + (x = CoordConversion.chunkBlockIndexGetX(polarBlockEntity.index())), y = CoordConversion.chunkBlockIndexGetY(polarBlockEntity.index()), chunkZ * 16 + (z = CoordConversion.chunkBlockIndexGetZ(polarBlockEntity.index())))), (BlockState)(blockState = chunkAccess.getBlockState(x, y, z)), (CompoundTag)compoundTag, (HolderLookup.Provider)(registryAccess = ((CraftServer)Bukkit.getServer()).getServer().registryAccess()))) == null) {
            return;
        }
        chunkAccess.blockEntities.put(blockPos, blockEntity);
    }

    private void loadSection(@NotNull PolarSection section, @NotNull ChunkAccess chunkAccess, LevelChunkSection chunkAccessSection) {
        BlockState first;
        int[] blockData = section.blockData();
        String[] rawBlockPalette = section.blockPalette();
        BlockState[] materialPalette = new BlockState[rawBlockPalette.length];
        for (int i = 0; i < rawBlockPalette.length; ++i) {
            try {
                materialPalette[i] = ((CraftBlockData)Bukkit.getServer().createBlockData(rawBlockPalette[i])).getState();
                continue;
            }
            catch (IllegalArgumentException e) {
                PolarPaper.logger().warning("Failed to parse block state: " + rawBlockPalette[i]);
                materialPalette[i] = Blocks.AIR.defaultBlockState();
            }
        }
        PalettedContainer states = chunkAccessSection.getStates();
        int bitsPerEntry = (int)Math.ceil(Math.log(rawBlockPalette.length) / Math.log(2.0));
        if (blockData == null && materialPalette.length == 1 && (first = materialPalette[0]).isAir()) {
            return;
        }
        states.data = blockData == null || bitsPerEntry == 0 ? new PalettedContainer.Data(PaletteUtil.getConfigurationForBitCount(0), (BitStorage)new ZeroBitStorage(4096), PaletteUtil.createPalette(0, Arrays.asList(materialPalette))) : new PalettedContainer.Data(PaletteUtil.getConfigurationForBitCount(bitsPerEntry), (BitStorage)new SimpleBitStorage(Math.max(4, bitsPerEntry), blockData.length, blockData), PaletteUtil.createPalette(bitsPerEntry, Arrays.asList(materialPalette)));
        chunkAccessSection.recalcBlockCounts();
    }

    public PolarWorld getPolarWorld() {
        return this.polarWorld;
    }

    public PolarWorldAccess getWorldAccess() {
        return this.worldAccess;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public boolean isParallelCapable() {
        return true;
    }

    @Nullable
    public Location getFixedSpawnLocation(@NotNull World world, @NotNull Random random) {
        Location loc = this.config.spawn();
        loc.setWorld(world);
        return loc;
    }

    @Nullable
    public static PolarGenerator fromWorld(World world) {
        ChunkGenerator generator = world.getGenerator();
        if (!(generator instanceof PolarGenerator)) {
            return null;
        }
        PolarGenerator polarGenerator = (PolarGenerator)generator;
        return polarGenerator;
    }
}

