/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.util.ExceptionUtil;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public record Config(int autoSaveIntervalTicks, long time, boolean saveOnStop, boolean loadOnStartup, @NotNull Location spawn, @NotNull Difficulty difficulty, boolean allowMonsters, boolean allowAnimals, boolean async, @NotNull WorldType worldType, @NotNull World.Environment environment, @NotNull Map<String, Object> gamerules) {
    public static final Map<String, Object> DEFAULT_GAMERULES = new HashMap<String, Object>(){
        {
            this.put("doMobSpawning", false);
            this.put("doFireTick", false);
            this.put("randomTickSpeed", 0);
            this.put("mobGriefing", false);
            this.put("doVinesSpread", false);
            this.put("tntExplodes", false);
            this.put("coralDeath", false);
            this.put("blockPhysics", true);
            this.put("blockGravity", true);
            this.put("liquidPhysics", true);
            this.put("maxCommandChainLength", 65536);
            this.put("commandModificationBlockLimit", 32768);
            this.put("maxCommandForkCount", 65536);
        }
    };
    public static final Config BLANK_DEFAULT = new Config(-1, 1000L, false, true, new Location(null, 0.0, 64.0, 0.0), Difficulty.NORMAL, true, true, false, WorldType.NORMAL, World.Environment.NORMAL, DEFAULT_GAMERULES);

    public static boolean isInConfig(@NotNull String worldName) {
        return PolarPaper.getPlugin().getConfig().isSet("worlds." + worldName);
    }

    public static Config getDefaultConfig(FileConfiguration config) {
        return Config.readPrefix(config, "default.", BLANK_DEFAULT);
    }

    @NotNull
    public static Config getWorldDefaultConfig(FileConfiguration config, World world) {
        Config defaultConfig = Config.getDefaultConfig(config);
        Builder configBuilder = defaultConfig.toBuilder().time(world.getTime()).spawn(world.getSpawnLocation()).difficulty(world.getDifficulty()).allowMonsters(world.getAllowMonsters()).allowAnimals(world.getAllowAnimals()).environment(world.getEnvironment());
        for (String name : world.getGameRules()) {
            Object gameRuleDefault;
            Object gameRuleValue;
            GameRule gamerule = GameRule.getByName((String)name);
            if (gamerule == null || (gameRuleValue = world.getGameRuleValue(gamerule)) == null || gameRuleValue == (gameRuleDefault = world.getGameRuleDefault(gamerule))) continue;
            configBuilder.gamerule(name, gameRuleValue);
        }
        return configBuilder.build();
    }

    @NotNull
    public String spawnString() {
        return Config.locationToString(this.spawn());
    }

    @NotNull
    public static Config readFromConfig(FileConfiguration config, World world) {
        return Config.readFromConfig(config, world.getName(), Config.getWorldDefaultConfig(config, world));
    }

    @NotNull
    public static Config readFromConfig(FileConfiguration config, String worldName) {
        return Config.readFromConfig(config, worldName, Config.getDefaultConfig(config));
    }

    @NotNull
    public static Config readFromConfig(FileConfiguration config, String worldName, Config defaultConfig) {
        return Config.readPrefix(config, String.format("worlds.%s.", worldName), defaultConfig);
    }

    @NotNull
    private static Config readPrefix(FileConfiguration config, String prefix, Config defaultConfig) {
        try {
            int autoSaveIntervalTicks = config.getInt(prefix + "autosaveIntervalTicks", defaultConfig.autoSaveIntervalTicks);
            long time = config.getLong(prefix + "time", defaultConfig.time);
            boolean saveOnStop = config.getBoolean(prefix + "saveOnStop", defaultConfig.saveOnStop);
            boolean loadOnStartup = config.getBoolean(prefix + "loadOnStartup", defaultConfig.loadOnStartup);
            String spawn = config.getString(prefix + "spawn", Config.locationToString(defaultConfig.spawn));
            Difficulty difficulty = Difficulty.valueOf((String)config.getString(prefix + "difficulty", defaultConfig.difficulty.name()));
            boolean allowMonsters = config.getBoolean(prefix + "allowMonsters", defaultConfig.allowMonsters);
            boolean allowAnimals = config.getBoolean(prefix + "allowAnimals", defaultConfig.allowAnimals);
            boolean async = config.getBoolean(prefix + "async", defaultConfig.async);
            WorldType worldType = WorldType.valueOf((String)config.getString(prefix + "worldType", defaultConfig.worldType.name()));
            World.Environment environment = World.Environment.valueOf((String)config.getString(prefix + "environment", defaultConfig.environment.name()));
            List gamerules = config.getMapList(prefix + "gamerules");
            HashMap<String, Object> gamerulesMap = new HashMap<String, Object>();
            Map<String, Object> convertedGamerules = Config.convertYmlGamerules(gamerules);
            gamerulesMap.putAll(defaultConfig.gamerules());
            gamerulesMap.putAll(convertedGamerules);
            return new Config(autoSaveIntervalTicks, time, saveOnStop, loadOnStartup, Config.stringToLocation(spawn), difficulty, allowMonsters, allowAnimals, async, worldType, environment, gamerulesMap);
        }
        catch (IllegalArgumentException e) {
            PolarPaper.logger().warning("Failed to read config, using defaults");
            ExceptionUtil.log(e);
            return defaultConfig;
        }
    }

    private static void writeProperty(FileConfiguration fileConfig, String path, Object value, Object def) {
        if (value.equals(def)) {
            fileConfig.set(path, null);
        } else {
            fileConfig.set(path, value);
        }
    }

    public static void writeToConfig(FileConfiguration fileConfig, String worldName, Config config) {
        Config defaultConfig = Config.getDefaultConfig(fileConfig);
        String prefix = String.format("worlds.%s.", worldName);
        Config.writeProperty(fileConfig, prefix + "time", config.time, defaultConfig.time);
        Config.writeProperty(fileConfig, prefix + "autosaveIntervalTicks", config.autoSaveIntervalTicks, defaultConfig.autoSaveIntervalTicks);
        fileConfig.setInlineComments(prefix + "autosaveIntervalTicks", List.of("-1 to disable"));
        Config.writeProperty(fileConfig, prefix + "saveOnStop", config.saveOnStop, defaultConfig.saveOnStop);
        Config.writeProperty(fileConfig, prefix + "loadOnStartup", config.loadOnStartup, defaultConfig.loadOnStartup);
        Config.writeProperty(fileConfig, prefix + "spawn", Config.locationToString(config.spawn), Config.locationToString(defaultConfig.spawn));
        Config.writeProperty(fileConfig, prefix + "difficulty", config.difficulty.name(), defaultConfig.difficulty.name());
        Config.writeProperty(fileConfig, prefix + "allowMonsters", config.allowMonsters, defaultConfig.allowMonsters);
        Config.writeProperty(fileConfig, prefix + "allowAnimals", config.allowAnimals, defaultConfig.allowAnimals);
        Config.writeProperty(fileConfig, prefix + "async", config.async, defaultConfig.async);
        fileConfig.setInlineComments(prefix + "async", List.of("Very experimental"));
        Config.writeProperty(fileConfig, prefix + "worldType", config.worldType.name(), defaultConfig.worldType.name());
        fileConfig.setInlineComments(prefix + "worldType", List.of("One of: NORMAL, FLAT, AMPLIFIED, LARGE_BIOMES"));
        Config.writeProperty(fileConfig, prefix + "environment", config.environment.name(), defaultConfig.environment.name());
        fileConfig.setInlineComments(prefix + "environment", List.of("One of: NORMAL, NETHER, THE_END, CUSTOM"));
        List<Map<String, Map<String, ?>>> gamerulesToSave = config.gamerulesList();
        gamerulesToSave.removeAll(defaultConfig.gamerulesList());
        if (gamerulesToSave.isEmpty()) {
            gamerulesToSave = null;
        }
        fileConfig.set(prefix + "gamerules", gamerulesToSave);
        fileConfig.setInlineComments(prefix + "gamerules", List.of("Custom rules: liquidPhysics, blockPhysics, blockGravity, coralDeath"));
        Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path configFile = pluginFolder.resolve("config.yml");
        try {
            fileConfig.save(configFile.toFile());
        }
        catch (IOException e) {
            PolarPaper.logger().warning("Failed to save world to config file");
            ExceptionUtil.log(e);
        }
    }

    private static String locationToString(Location spawn) {
        return String.format("%s, %s, %s, %s, %s", spawn.x(), spawn.y(), spawn.z(), Float.valueOf(spawn.getYaw()), Float.valueOf(spawn.getPitch()));
    }

    private static Location stringToLocation(String string) {
        String[] split = string.split(",");
        try {
            if (split.length == 3) {
                String x = split[0];
                String y = split[1];
                String z = split[2];
                return new Location(null, Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(z));
            }
            if (split.length == 5) {
                String x = split[0];
                String y = split[1];
                String z = split[2];
                String yaw = split[3];
                String pitch = split[4];
                return new Location(null, Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(z), Float.parseFloat(yaw), Float.parseFloat(pitch));
            }
            PolarPaper.logger().warning("Failed to parse spawn pos: " + string);
            return Config.BLANK_DEFAULT.spawn;
        }
        catch (Exception e) {
            PolarPaper.logger().warning("Failed to parse spawn pos: " + string);
            return Config.BLANK_DEFAULT.spawn;
        }
    }

    @NotNull
    public List<Map<String, ?>> gamerulesList() {
        ArrayList gamerules = new ArrayList();
        for (Map.Entry<String, Object> entry : this.gamerules().entrySet()) {
            gamerules.add(Map.of(entry.getKey(), entry.getValue()));
        }
        return gamerules;
    }

    @NotNull
    public static Map<String, Object> convertYmlGamerules(List<Map<?, ?>> ymlGamerules) {
        HashMap<String, Object> gamerules = new HashMap<String, Object>();
        for (Map<?, ?> ymlGamerule : ymlGamerules) {
            for (Map.Entry<?, ?> entry : ymlGamerule.entrySet()) {
                Object obj = entry.getKey();
                if (!(obj instanceof String)) continue;
                String key = (String)obj;
                gamerules.put(key, entry.getValue());
            }
        }
        return gamerules;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private int autoSaveIntervalTicks;
        private long time;
        private boolean saveOnStop;
        private boolean loadOnStartup;
        @NotNull
        private Location spawn;
        @NotNull
        private Difficulty difficulty;
        private boolean allowMonsters;
        private boolean allowAnimals;
        private boolean async;
        @NotNull
        private WorldType worldType;
        @NotNull
        private World.Environment environment;
        @NotNull
        private Map<String, Object> gamerules;

        private Builder(Config record) {
            this.autoSaveIntervalTicks = record.autoSaveIntervalTicks;
            this.time = record.time;
            this.saveOnStop = record.saveOnStop;
            this.loadOnStartup = record.loadOnStartup;
            this.spawn = record.spawn;
            this.difficulty = record.difficulty;
            this.allowMonsters = record.allowMonsters;
            this.allowAnimals = record.allowAnimals;
            this.async = record.async;
            this.worldType = record.worldType;
            this.environment = record.environment;
            this.gamerules = record.gamerules;
        }

        public Builder autoSaveIntervalTicks(int autoSaveIntervalTicks) {
            this.autoSaveIntervalTicks = autoSaveIntervalTicks;
            return this;
        }

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Builder saveOnStop(boolean saveOnStop) {
            this.saveOnStop = saveOnStop;
            return this;
        }

        public Builder loadOnStartup(boolean loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
            return this;
        }

        public Builder spawn(@NotNull Location spawn) {
            this.spawn = Objects.requireNonNull(spawn, "Null spawn");
            return this;
        }

        public Builder difficulty(@NotNull Difficulty difficulty) {
            this.difficulty = Objects.requireNonNull(difficulty, "Null difficulty");
            return this;
        }

        public Builder allowMonsters(boolean allowMonsters) {
            this.allowMonsters = allowMonsters;
            return this;
        }

        public Builder allowAnimals(boolean allowAnimals) {
            this.allowAnimals = allowAnimals;
            return this;
        }

        public Builder async(boolean async) {
            this.async = async;
            return this;
        }

        public Builder worldType(@NotNull WorldType worldType) {
            this.worldType = Objects.requireNonNull(worldType, "Null worldType");
            return this;
        }

        public Builder environment(@NotNull World.Environment environment) {
            this.environment = Objects.requireNonNull(environment, "Null environment");
            return this;
        }

        public Builder gamerules(@NotNull Map<String, Object> gamerules) {
            this.gamerules = gamerules;
            return this;
        }

        public Builder gamerule(@NotNull String gameruleKey, @NotNull Object gameruleValue) {
            this.gamerules.put(gameruleKey, gameruleValue);
            return this;
        }

        public Config build() {
            return new Config(this.autoSaveIntervalTicks, this.time, this.saveOnStop, this.loadOnStartup, this.spawn, this.difficulty, this.allowMonsters, this.allowAnimals, this.async, this.worldType, this.environment, this.gamerules);
        }
    }
}

