/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import live.minehub.polarpaper.Polar;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class LoadCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        String worldName = (String)ctx.getArgument("worldname", String.class);
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld != null) {
            PolarWorld polarWorld = PolarWorld.fromWorld(bukkitWorld);
            if (polarWorld == null) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Non-polar world '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' already loaded!", (TextColor)NamedTextColor.RED)));
            } else {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Polar world '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"' already loaded!", (TextColor)NamedTextColor.RED)));
            }
            return 1;
        }
        Path pluginFolder = Path.of(PolarPaper.getPlugin().getDataFolder().getAbsolutePath(), new String[0]);
        Path worldsFolder = pluginFolder.resolve("worlds");
        Path path = worldsFolder.resolve(worldName + ".polar");
        if (!Files.exists(path, new LinkOption[0])) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)("Couldn't find file '" + worldName + ".polar' in the worlds folder"), (TextColor)NamedTextColor.RED));
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Loading '", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"'...", (TextColor)NamedTextColor.GRAY)));
        Polar.loadWorldFromFile(worldName).thenAccept(world -> {
            boolean successful;
            boolean bl = successful = world != null;
            if (successful) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Loaded '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"'. ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"Use ", (TextColor)NamedTextColor.AQUA))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"/polar goto ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.runCommand((String)("/polar goto " + worldName)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to run")))).decorate(TextDecoration.UNDERLINED))).append((Component)Component.text((String)" to teleport now", (TextColor)NamedTextColor.AQUA)));
            } else {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Failed to load world '", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)worldName, (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"'", (TextColor)NamedTextColor.RED)));
            }
        });
        return 1;
    }
}

