/*
 * Decompiled with CFR 0.152.
 */
package live.minehub.polarpaper.commands;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import live.minehub.polarpaper.BlockSelector;
import live.minehub.polarpaper.PolarPaper;
import live.minehub.polarpaper.PolarWorld;
import live.minehub.polarpaper.PolarWorldAccess;
import live.minehub.polarpaper.PolarWriter;
import live.minehub.polarpaper.schematic.Schematic;
import live.minehub.polarpaper.source.FilePolarSource;
import live.minehub.polarpaper.userdata.WorldUserData;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.joml.Vector3i;

public class CreateFromRegionCommand {
    protected static int run(CommandContext<CommandSourceStack> ctx) {
        return CreateFromRegionCommand.convert(ctx);
    }

    private static int convert(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (!(sender instanceof Player)) {
            return 1;
        }
        Player player = (Player)sender;
        World bukkitWorld = player.getWorld();
        String newWorldName = (String)ctx.getArgument("newworldname", String.class);
        long before = System.nanoTime();
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Creating world '", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"' from selected region...", (TextColor)NamedTextColor.GRAY)));
        PolarWorld polarWorld = new PolarWorld(-4, 19);
        PersistentDataContainer data = player.getPersistentDataContainer();
        int[] pos1Array = (int[])data.get(Schematic.POS_1_KEY, PersistentDataType.INTEGER_ARRAY);
        int[] pos2Array = (int[])data.get(Schematic.POS_2_KEY, PersistentDataType.INTEGER_ARRAY);
        if (pos1Array == null || pos2Array == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"You need to select two corners with the polar wand!", (TextColor)NamedTextColor.RED));
            return 1;
        }
        Vector3i pos1 = new Vector3i(pos1Array);
        Vector3i pos2 = new Vector3i(pos2Array);
        BlockSelector.RegionBlockSelector blockSelector = BlockSelector.RegionBlockSelector.fromCorners(pos1, pos2);
        Vector3i schemOffset = player.getLocation().toVector().toVector3i();
        Bukkit.getAsyncScheduler().runNow((Plugin)PolarPaper.getPlugin(), task -> {
            polarWorld.updateChunks(bukkitWorld, PolarWorldAccess.POLAR_PAPER_FEATURES, blockSelector);
            polarWorld.userData(WorldUserData.writeSchematicOffset(schemOffset));
            byte[] worldBytes = PolarWriter.write(polarWorld);
            FilePolarSource.defaultFolder(newWorldName).saveBytes(worldBytes);
            int ms = (int)((System.nanoTime() - before) / 1000000L);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Converted '", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"' in ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((int)ms, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"ms. ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"\nUse ", (TextColor)NamedTextColor.AQUA))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"/polar paste ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.runCommand((String)("/polar paste " + newWorldName)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to run")))).decorate(TextDecoration.UNDERLINED))).append((Component)Component.text((String)" to paste it now", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"\nUse ", (TextColor)NamedTextColor.AQUA))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"/polar load ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)newWorldName, (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.runCommand((String)("/polar load " + newWorldName)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to run")))).decorate(TextDecoration.UNDERLINED))).append((Component)Component.text((String)" to load it now", (TextColor)NamedTextColor.AQUA)));
        });
        return 1;
    }
}

