/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformpapernms1216;

import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import com.destroystokyo.paper.util.SneakyThrow;
import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.util.ForwardedInt2ObjectMap;
import de.pianoman911.playerculling.platformcommon.util.ReflectionUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spigotmc.AsyncCatcher;

public final class DelegatedTrackedEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PlayerCulling");
    private static final MethodHandle SET_ENTITY_MAP = ReflectionUtil.getSetter(ChunkMap.class, Int2ObjectMap.class, 0);
    private static final MethodHandle GET_ENTITY = ReflectionUtil.getGetter(ChunkMap.TrackedEntity.class, Entity.class, 0);
    private static final MethodHandle GET_RANGE = ReflectionUtil.getGetter(ChunkMap.TrackedEntity.class, Integer.TYPE, 0);
    private static final MethodHandle GET_LAST_SECTION_POS = ReflectionUtil.getGetter(ChunkMap.TrackedEntity.class, SectionPos.class, 0);
    private static final MethodHandle GET_LAST_CHUNK_UPDATE = ReflectionUtil.getGetter(ChunkMap.TrackedEntity.class, Long.TYPE, 0);
    private static final MethodHandle GET_LAST_TRACKED_CHUNK = ReflectionUtil.getGetter(ChunkMap.TrackedEntity.class, NearbyPlayers.TrackedChunk.class, 0);
    private static final MethodHandle SET_SERVER_ENTITY = ReflectionUtil.getSetter(ChunkMap.TrackedEntity.class, ServerEntity.class, 0);
    private static final MethodHandle SET_LAST_SECTION_POS = ReflectionUtil.getSetter(ChunkMap.TrackedEntity.class, SectionPos.class, 0);
    private static final MethodHandle SET_SEEN_BY = ReflectionUtil.getSetter(ChunkMap.TrackedEntity.class, Set.class, 0);
    private static final MethodHandle SET_LAST_CHUNK_UPDATE = ReflectionUtil.getSetter(ChunkMap.TrackedEntity.class, Long.TYPE, 0);
    private static final MethodHandle SET_LAST_TRACKED_CHUNK = ReflectionUtil.getSetter(ChunkMap.TrackedEntity.class, NearbyPlayers.TrackedChunk.class, 0);
    private static final MethodHandle GET_UPDATE_INTERVAL = ReflectionUtil.getGetter(ServerEntity.class, Integer.TYPE, 3);
    private static final MethodHandle GET_TRACK_DELTA = ReflectionUtil.getGetter(ServerEntity.class, Boolean.TYPE, 0);

    private DelegatedTrackedEntity() {
    }

    public static void injectChunkMap(ChunkMap chunkMap, CullShip ship) {
        try {
            SET_ENTITY_MAP.invoke(chunkMap, new CustomEntityMap(chunkMap, ship));
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
        }
    }

    public static void uninjectChunkMap(ChunkMap map) {
        Int2ObjectMap int2ObjectMap = map.entityMap;
        if (!(int2ObjectMap instanceof CustomEntityMap)) {
            return;
        }
        CustomEntityMap customMap = (CustomEntityMap)int2ObjectMap;
        try {
            customMap.uninject();
            SET_ENTITY_MAP.invoke(map, customMap.getDelegate());
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
        }
    }

    public static ChunkMap.TrackedEntity constructDelegate(ChunkMap map, ChunkMap.TrackedEntity entity, CullShip ship) throws Throwable {
        final Entity mcEntity = GET_ENTITY.invoke(entity);
        if (!(mcEntity instanceof ServerPlayer)) {
            return entity;
        }
        int range = GET_RANGE.invoke(entity);
        int updateInterval = GET_UPDATE_INTERVAL.invoke(entity.serverEntity);
        boolean trackDelta = GET_TRACK_DELTA.invoke(entity.serverEntity);
        final CullPlayer player = ship.getPlayer(mcEntity.getUUID());
        if (player == null) {
            LOGGER.error("Failed to construct delegated tracked entity for player {} ({}), no CullPlayer found - This is a rare edge case, please report this! PlayerCulling will be disabled for this player.", (Object)mcEntity.getScoreboardName(), (Object)mcEntity.getUUID());
            return entity;
        }
        ChunkMap chunkMap = map;
        Objects.requireNonNull(chunkMap);
        ChunkMap.TrackedEntity delegated = new ChunkMap.TrackedEntity(chunkMap, mcEntity, range, updateInterval, trackDelta){
            private final CullPlayer cullPlayer;
            private final MethodHandle getCullPlayer;
            {
                ChunkMap chunkMap = x0;
                Objects.requireNonNull(chunkMap);
                super(chunkMap, arg0, arg1, arg2, arg3);
                this.cullPlayer = player;
                this.getCullPlayer = ReflectionUtil.getGetter(((Object)((Object)this)).getClass(), CullPlayer.class, 0);
            }

            public void updatePlayer(@NotNull ServerPlayer player2) {
                AsyncCatcher.catchOp((String)"player tracker update");
                if (player2 == mcEntity) {
                    return;
                }
                ChunkMap.TrackedEntity trackedPlayer = player2.moonrise$getTrackedEntity();
                if (!((Object)((Object)this)).getClass().isInstance(trackedPlayer)) {
                    super.updatePlayer(player2);
                    return;
                }
                try {
                    CullPlayer cullPlayer = this.getCullPlayer.invoke(trackedPlayer);
                    if (!cullPlayer.isHidden(mcEntity.getUUID())) {
                        super.updatePlayer(player2);
                    } else if (this.seenBy.remove(player2.connection)) {
                        this.serverEntity.removePairing(player2);
                    }
                }
                catch (Throwable throwable) {
                    SneakyThrow.sneaky((Throwable)throwable);
                }
            }
        };
        SET_SERVER_ENTITY.invoke(delegated, entity.serverEntity);
        SET_LAST_SECTION_POS.invoke(delegated, GET_LAST_SECTION_POS.invoke(entity));
        SET_SEEN_BY.invoke(delegated, entity.seenBy);
        SET_LAST_CHUNK_UPDATE.invoke(delegated, GET_LAST_CHUNK_UPDATE.invoke(entity));
        SET_LAST_TRACKED_CHUNK.invoke(delegated, GET_LAST_TRACKED_CHUNK.invoke(entity));
        return delegated;
    }

    private static final class CustomEntityMap
    extends ForwardedInt2ObjectMap<ChunkMap.TrackedEntity> {
        private final Int2ObjectMap<ChunkMap.TrackedEntity> uninjectedMap = new Int2ObjectOpenHashMap();
        private final ChunkMap chunkMap;
        private final CullShip ship;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ChunkMap.TrackedEntity nextInsert;

        public CustomEntityMap(ChunkMap chunkMap, CullShip ship) {
            super(chunkMap.entityMap);
            this.chunkMap = chunkMap;
            this.ship = ship;
        }

        public void uninject() {
            this.getDelegate().putAll(this.uninjectedMap);
            this.uninjectedMap.clear();
        }

        @Override
        public ChunkMap.TrackedEntity put(int entityId, ChunkMap.TrackedEntity entity) {
            try {
                Entity mcEntity = GET_ENTITY.invoke(entity);
                if (!(mcEntity instanceof ServerPlayer)) {
                    return super.put(entityId, entity);
                }
                if (this.nextInsert != null) {
                    throw new IllegalStateException("PlayerCulling failed to inject into entity tracker, please report this error!");
                }
                this.nextInsert = entity;
                return null;
            }
            catch (Throwable throwable) {
                SneakyThrow.sneaky((Throwable)throwable);
                throw new AssertionError();
            }
        }

        private void fixInsert() {
            if (this.nextInsert == null) {
                return;
            }
            try {
                Entity mcEntity = GET_ENTITY.invoke(this.nextInsert);
                ChunkMap.TrackedEntity delegate = DelegatedTrackedEntity.constructDelegate(this.chunkMap, this.nextInsert, this.ship);
                if (delegate != this.nextInsert) {
                    this.uninjectedMap.put(mcEntity.getId(), (Object)this.nextInsert);
                    mcEntity.moonrise$setTrackedEntity(delegate);
                }
                super.put(mcEntity.getId(), delegate);
            }
            catch (Throwable throwable) {
                SneakyThrow.sneaky((Throwable)throwable);
            }
            finally {
                this.nextInsert = null;
            }
        }

        @Override
        public ChunkMap.TrackedEntity remove(int key) {
            this.uninjectedMap.remove(key);
            return (ChunkMap.TrackedEntity)super.remove(key);
        }

        @Override
        @NotNull
        public ObjectCollection<ChunkMap.TrackedEntity> values() {
            this.fixInsert();
            return super.values();
        }
    }
}

