/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformpaper.platform;

import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import de.pianoman911.playerculling.platformcommon.platform.world.PlatformChunkAccess;
import de.pianoman911.playerculling.platformcommon.platform.world.PlatformWorld;
import de.pianoman911.playerculling.platformcommon.vector.Vec3d;
import de.pianoman911.playerculling.platformcommon.vector.Vec3i;
import de.pianoman911.playerculling.platformpaper.platform.PaperPlatform;
import de.pianoman911.playerculling.platformpaper.platform.PaperPlayer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperWorld
extends PlatformWorld {
    private final World world;
    private final PaperPlatform platform;

    public PaperWorld(World world, PaperPlatform platform) {
        super(platform);
        this.world = world;
        this.platform = platform;
        this.platform.getNmsAdapter().injectWorld(this.platform, world);
    }

    @Override
    public @Nullable PlatformChunkAccess getChunkAccess(int x, int z) {
        return this.platform.getNmsAdapter().provideChunkAccess(this.platform, this.world, x, z);
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public Key getKey() {
        return this.world.getKey();
    }

    @Override
    public int getMinY() {
        return this.world.getMinHeight();
    }

    @Override
    public int getMaxY() {
        return this.world.getMaxHeight();
    }

    @Override
    public int getTrackingDistance() {
        return this.platform.getNmsAdapter().getTrackingDistance(this.world);
    }

    @Override
    public int getTrackingDistance(PlatformPlayer player) {
        return Math.min(player.getTrackingDistance(), this.getTrackingDistance());
    }

    @Override
    protected List<PlatformPlayer> getPlayers0() {
        ArrayList<PlatformPlayer> players = new ArrayList<PlatformPlayer>(this.world.getPlayerCount());
        for (PaperPlayer platformPlayer : this.platform.getPlayers()) {
            Player paperPlayer = (Player)platformPlayer.getDelegate();
            if (!paperPlayer.isConnected() || paperPlayer.getWorld() != this.world || platformPlayer.isSpectator() || platformPlayer.shouldPreventCulling()) continue;
            players.add(platformPlayer);
        }
        return players;
    }

    @Override
    public @Nullable Vec3d rayTraceBlocks(Vec3d start, Vec3d dir, double maxDistance) {
        return this.platform.getNmsAdapter().rayTraceBlocks(this, start, dir, maxDistance);
    }

    @Override
    public void spawnColoredParticle(double x, double y, double z, Color color, float size) {
        int rgb = color.getRGB() & 0xFFFFFF;
        Particle.DUST.builder().allPlayers().location(this.world, x, y, z).color(org.bukkit.Color.fromRGB((int)rgb), size).force(true).spawn();
    }

    @Override
    public String getBlockStateStringOfBlock(Vec3i blockPos) {
        BlockData data = this.world.getBlockAt(blockPos.getX(), blockPos.getY(), blockPos.getZ()).getBlockData();
        return data.getAsString(true);
    }

    public World getWorld() {
        return this.world;
    }
}

