/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformpaper.platform;

import de.pianoman911.playerculling.platformcommon.AABB;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformEntity;
import de.pianoman911.playerculling.platformcommon.platform.world.PlatformWorld;
import de.pianoman911.playerculling.platformcommon.util.TickRefreshSupplier;
import de.pianoman911.playerculling.platformcommon.vector.Vec3d;
import de.pianoman911.playerculling.platformpaper.platform.PaperCommandSender;
import de.pianoman911.playerculling.platformpaper.platform.PaperPlatform;
import de.pianoman911.playerculling.platformpaper.platform.PaperWorld;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperEntity<T extends Entity>
extends PaperCommandSender<T>
implements PlatformEntity {
    protected final TickRefreshSupplier<Vec3d> position;
    protected final TickRefreshSupplier<AABB> aabb;

    public PaperEntity(PaperPlatform platform, T sender) {
        super(platform, sender);
        this.position = new TickRefreshSupplier<Vec3d>(platform, () -> new Vec3d(sender.getX(), sender.getY(), sender.getZ()));
        this.aabb = new TickRefreshSupplier<AABB>(platform, () -> {
            BoundingBox boundingBox = sender.getBoundingBox();
            return new AABB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        });
    }

    @Override
    public UUID getUniqueId() {
        return ((Entity)this.getDelegate()).getUniqueId();
    }

    @Override
    public String getName() {
        return ((Entity)this.getDelegate()).getName();
    }

    @Override
    public PlatformWorld getWorld() {
        return this.platform.provideWorld(((Entity)this.getDelegate()).getWorld());
    }

    @Override
    public Vec3d getPosition() {
        return this.position.get();
    }

    @Override
    public AABB getBoundingBox() {
        return this.aabb.get();
    }

    @Override
    public void teleport(PlatformWorld world, double x, double y, double z) {
        ((Entity)this.getDelegate()).teleportAsync(new Location(((PaperWorld)world).getWorld(), x, y, z));
    }
}

