/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformpaper;

import de.pianoman911.playerculling.bstats.bukkit.Metrics;
import de.pianoman911.playerculling.core.commands.PlayerCullingCommand;
import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformpaper.PlayerCullingListener;
import de.pianoman911.playerculling.platformpaper.platform.PaperCommandSourceStack;
import de.pianoman911.playerculling.platformpaper.platform.PaperPlatform;
import de.pianoman911.playerculling.platformpaper.platform.PaperWorld;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PlayerCullingPlugin
extends JavaPlugin {
    private final PaperPlatform platform = this.buildPlatform();
    private @MonotonicNonNull CullShip cullShip;

    public void onLoad() {
        this.cullShip = new CullShip(this.getPlatform());
        new Metrics((Plugin)this, 25595);
    }

    public void onEnable() {
        this.cullShip.enable();
        this.getPlatform().getNmsAdapter().init(this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerCullingListener(this), (Plugin)this);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            this.cullShip.addPlayer(new CullPlayer(this.cullShip, this.getPlatform().providePlayer(onlinePlayer)));
        }
        this.getPlatform().getNmsAdapter().injectNetwork(this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> ((Commands)event.registrar()).register(PlayerCullingCommand.createConverted(this.cullShip, platform -> ((PaperCommandSourceStack)platform).getPaperSourceStack(), this.getPlatform()::provideCommandSourceStack)));
    }

    public void onDisable() {
        this.getPlatform().getNmsAdapter().uninjectNetwork(this);
        for (PaperWorld world : this.getPlatform().getPaperWorlds()) {
            this.getPlatform().getNmsAdapter().uninjectWorld(world.getWorld());
        }
    }

    protected PaperPlatform buildPlatform() {
        return new PaperPlatform(this);
    }

    public PaperPlatform getPlatform() {
        return this.platform;
    }

    public CullShip getCullShip() {
        return this.cullShip;
    }
}

