/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformcommon.config;

import de.pianoman911.playerculling.platformcommon.config.serializer.KyoriKeySerializer;
import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import org.jspecify.annotations.NullMarked;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

@NullMarked
public class YamlConfigHolder<T> {
    private static final YamlConfigurationLoader.Builder CONFIG_BUILDER = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().nodeStyle(NodeStyle.BLOCK).defaultOptions(options -> options.serializers(collection -> collection.register((TypeToken)new TypeToken<Key>(){}, (TypeSerializer)KyoriKeySerializer.INSTANCE)))).indent(2);
    private final Class<T> clazz;
    private final Path path;
    private final YamlConfigurationLoader loader;
    private final Set<Consumer<T>> reloadHooks = new HashSet<Consumer<T>>();
    private T config;

    public YamlConfigHolder(Class<T> clazz, Path path) {
        this.clazz = clazz;
        this.path = path;
        this.loader = ((YamlConfigurationLoader.Builder)CONFIG_BUILDER.path(path)).build();
        this.config = this.reloadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReloadHook(Consumer<T> consumer) {
        YamlConfigHolder yamlConfigHolder = this;
        synchronized (yamlConfigHolder) {
            this.reloadHooks.add(consumer);
        }
    }

    public void addReloadHookAndRun(Consumer<T> consumer) {
        this.addReloadHook(consumer);
        consumer.accept(this.config);
    }

    public T reloadConfig() {
        YamlConfigHolder yamlConfigHolder = this;
        synchronized (yamlConfigHolder) {
            try {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                this.config = this.clazz.cast(((CommentedConfigurationNode)this.loader.load()).get(this.clazz));
                this.saveConfig();
                for (Consumer<T> runnable : this.reloadHooks) {
                    runnable.accept(this.config);
                }
                return this.config;
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to load config", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        YamlConfigHolder yamlConfigHolder = this;
        synchronized (yamlConfigHolder) {
            try {
                this.loader.save((ConfigurationNode)((CommentedConfigurationNode)this.loader.createNode()).set(this.clazz, this.config));
            }
            catch (ConfigurateException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getDelegate() {
        YamlConfigHolder yamlConfigHolder = this;
        synchronized (yamlConfigHolder) {
            return this.config;
        }
    }
}

