/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformcommon.config;

import de.pianoman911.playerculling.platformcommon.util.WaypointMode;
import java.util.Set;
import net.kyori.adventure.key.Key;
import org.jspecify.annotations.NullUnmarked;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
@NullUnmarked
public final class PlayerCullingConfig {
    public int configVersion = 1;
    public Scheduler scheduler = new Scheduler();
    public Culling culling = new Culling();
    public Updater updater = new Updater();
    public WaypointMode waypointMode = WaypointMode.HIDDEN;

    @ConfigSerializable
    public static final class Scheduler {
        public int maxThreads = Runtime.getRuntime().availableProcessors() / 3;
        public int cleanupInterval = 30;
        public int containerTtl = 30;
        public int maxCullTime = 45;
        public double maxTransferFactor = 0.7;
        public double maxMergeFactor = 0.5;

        public long getMaxCullTimeNs() {
            return (long)this.maxCullTime * 1000000L;
        }

        public long getCleanupIntervalMs() {
            return (long)this.cleanupInterval * 1000L;
        }

        public long getContainerTtlMs() {
            return (long)this.containerTtl * 1000L;
        }

        public double getMaxTransferNs() {
            return this.maxTransferFactor * (double)this.getMaxCullTimeNs();
        }

        public double getMaxMergeNs() {
            return this.maxMergeFactor * (double)this.getMaxCullTimeNs();
        }
    }

    @ConfigSerializable
    public static final class Culling {
        public double nametagVisibilityDistance = 64.0;
        public Set<Key> blacklistedWorlds = Set.of();

        public double getNametagVisibilityDistanceSquared() {
            return this.nametagVisibilityDistance * this.nametagVisibilityDistance;
        }
    }

    @ConfigSerializable
    public static final class Updater {
        public boolean enabled = true;
        public boolean notifyAdmins = true;
        public int intervalHours = 24;

        public long getIntervalMs() {
            return (long)this.intervalHours * 3600000L;
        }
    }
}

