/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.occlusion;

import de.pianoman911.playerculling.core.occlusion.FacedOcclusionStepping;
import de.pianoman911.playerculling.platformcommon.cache.DataProvider;
import de.pianoman911.playerculling.platformcommon.vector.Vec3d;
import de.pianoman911.playerculling.platformcommon.vector.Vec3i;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcclusionCullingInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PlayerCulling");
    private static final double SAFE_POINT_OFFSET = 0.05;
    private static final double TWO_SAFE_POINT_OFFSET = 0.1;
    private static final double POINT_START = 0.05;
    private static final double POINT_END = 0.95;
    private static final double POINT_MIDDLE = 0.5;
    private static final double DELTA = 1.0;
    private static final byte ON_MIN_X = 1;
    private static final byte ON_MAX_X = 2;
    private static final byte ON_MIN_Y = 4;
    private static final byte ON_MAX_Y = 8;
    private static final byte ON_MIN_Z = 16;
    private static final byte ON_MAX_Z = 32;
    private final DataProvider provider;
    private final Vec3i startVoxel = new Vec3i(0, 0, 0);
    private long raySteps;

    public OcclusionCullingInstance(DataProvider provider) {
        this.provider = provider;
    }

    private static boolean deltaLowerThanX(double a, double b) {
        return Math.abs(a - b) < 1.0;
    }

    private static double safePointEndOffset(double target, double max) {
        return Math.min(target + 0.95, max - 0.05);
    }

    private static double safeMiddleOffset(double target, double max) {
        if (target + 0.5 < max - 0.05) {
            return target + 0.5;
        }
        return target + 0.05 + (max - 0.05 - (target + 0.05)) * 0.5;
    }

    public boolean isAABBVisible(Vec3d aabbMin, Vec3d aabbMax, Vec3d viewerPosition) {
        return this.isAABBVisible(aabbMin.x, aabbMin.y, aabbMin.z, aabbMax.x, aabbMax.y, aabbMax.z, viewerPosition);
    }

    public boolean isAABBVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vec3d viewerPosition) {
        try {
            Vec3i startVoxel = viewerPosition.toVec3iFloored(this.startVoxel);
            Relative relX = Relative.from(minX, maxX, viewerPosition.x);
            Relative relY = Relative.from(minY, maxY, viewerPosition.y);
            Relative relZ = Relative.from(minZ, maxZ, viewerPosition.z);
            if (relX == Relative.INSIDE && relY == Relative.INSIDE && relZ == Relative.INSIDE) {
                return true;
            }
            for (double x = minX; x < maxX - 0.1; x += 1.0) {
                byte visibleOnFaceX = 0;
                byte faceEdgeDataX = 0;
                faceEdgeDataX = (byte)(faceEdgeDataX | (OcclusionCullingInstance.deltaLowerThanX(x, minX) ? 1 : 0));
                faceEdgeDataX = (byte)(faceEdgeDataX | (OcclusionCullingInstance.deltaLowerThanX(x, maxX) ? 2 : 0));
                visibleOnFaceX = (byte)(visibleOnFaceX | (OcclusionCullingInstance.deltaLowerThanX(x, minX) && relX == Relative.POSITIVE ? 1 : 0));
                visibleOnFaceX = (byte)(visibleOnFaceX | (OcclusionCullingInstance.deltaLowerThanX(x, maxX) && relX == Relative.NEGATIVE ? 2 : 0));
                for (double y = minY; y < maxY - 0.1; y += 1.0) {
                    byte faceEdgeDataY = faceEdgeDataX;
                    byte visibleOnFaceY = visibleOnFaceX;
                    faceEdgeDataY = (byte)(faceEdgeDataY | (OcclusionCullingInstance.deltaLowerThanX(y, minY) ? 4 : 0));
                    faceEdgeDataY = (byte)(faceEdgeDataY | (OcclusionCullingInstance.deltaLowerThanX(y, maxY) ? 8 : 0));
                    visibleOnFaceY = (byte)(visibleOnFaceY | (OcclusionCullingInstance.deltaLowerThanX(y, minY) && relY == Relative.POSITIVE ? 4 : 0));
                    visibleOnFaceY = (byte)(visibleOnFaceY | (OcclusionCullingInstance.deltaLowerThanX(y, maxY) && relY == Relative.NEGATIVE ? 8 : 0));
                    for (double z = minZ; z < maxZ - 0.1; z += 1.0) {
                        byte faceEdgeData = faceEdgeDataY;
                        byte visibleOnFace = visibleOnFaceY;
                        faceEdgeData = (byte)(faceEdgeData | (OcclusionCullingInstance.deltaLowerThanX(z, minZ) ? 16 : 0));
                        faceEdgeData = (byte)(faceEdgeData | (OcclusionCullingInstance.deltaLowerThanX(z, maxZ) ? 32 : 0));
                        visibleOnFace = (byte)(visibleOnFace | (OcclusionCullingInstance.deltaLowerThanX(z, minZ) && relZ == Relative.POSITIVE ? 16 : 0));
                        if ((visibleOnFace = (byte)(visibleOnFace | (OcclusionCullingInstance.deltaLowerThanX(z, maxZ) && relZ == Relative.NEGATIVE ? 32 : 0))) == 0 || !this.isVoxelVisible(viewerPosition, startVoxel, x, y, z, faceEdgeData, visibleOnFace, maxX, maxY, maxZ)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            LOGGER.error("Error while culling", throwable);
            return true;
        }
    }

    private boolean isVoxelVisible(Vec3d posStart, Vec3i startVoxel, double targetX, double targetY, double targetZ, byte faceData, byte visibleOnFace, double maxX, double maxY, double maxZ) {
        int dotselectors = 0;
        if ((visibleOnFace & 1) == 1) {
            dotselectors = (short)(dotselectors | 0x101);
            if ((faceData & 0xFFFFFFFE) != 0) {
                dotselectors = (short)(dotselectors | 0x32);
            }
        }
        if ((visibleOnFace & 4) == 4) {
            dotselectors = (short)(dotselectors | 0x201);
            if ((faceData & 0xFFFFFFFB) != 0) {
                dotselectors = (short)(dotselectors | 0x98);
            }
        }
        if ((visibleOnFace & 0x10) == 16) {
            dotselectors = (short)(dotselectors | 0x401);
            if ((faceData & 0xFFFFFFEF) != 0) {
                dotselectors = (short)(dotselectors | 0x32);
            }
        }
        double targetBeginX = targetX + 0.05;
        double targetBeginY = targetY + 0.05;
        double targetBeginZ = targetZ + 0.05;
        if ((dotselectors & 1) == 1 && this.scanVisible(posStart, startVoxel, targetBeginX, targetBeginY, targetBeginZ)) {
            return true;
        }
        if ((visibleOnFace & 8) == 8) {
            dotselectors = (short)(dotselectors | 0x1002);
            if ((faceData & 0xFFFFFFF7) != 0) {
                dotselectors = (short)(dotselectors | 0x64);
            }
        }
        double targetEndY = OcclusionCullingInstance.safePointEndOffset(targetY, maxY);
        if ((dotselectors & 2) == 2 && this.scanVisible(posStart, startVoxel, targetBeginX, targetEndY, targetBeginZ)) {
            return true;
        }
        if ((visibleOnFace & 0x20) == 32) {
            dotselectors = (short)(dotselectors | 0x2004);
            if ((faceData & 0xFFFFFFDF) != 0) {
                dotselectors = (short)(dotselectors | 0xC8);
            }
        }
        double targetEndZ = OcclusionCullingInstance.safePointEndOffset(targetZ, maxZ);
        if ((dotselectors & 4) == 4 && this.scanVisible(posStart, startVoxel, targetBeginX, targetEndY, targetEndZ)) {
            return true;
        }
        if ((dotselectors & 8) == 8 && this.scanVisible(posStart, startVoxel, targetBeginX, targetBeginY, targetEndZ)) {
            return true;
        }
        if ((visibleOnFace & 2) == 2) {
            dotselectors = (short)(dotselectors | 0x810);
            if ((faceData & 0xFFFFFFFD) != 0) {
                dotselectors = (short)(dotselectors | 0xE0);
            }
        }
        double targetEndX = OcclusionCullingInstance.safePointEndOffset(targetX, maxX);
        if ((dotselectors & 0x10) == 16 && this.scanVisible(posStart, startVoxel, targetEndX, targetBeginY, targetBeginZ)) {
            return true;
        }
        if ((dotselectors & 0x20) == 32 && this.scanVisible(posStart, startVoxel, targetEndX, targetEndY, targetBeginZ)) {
            return true;
        }
        if ((dotselectors & 0x40) == 64 && this.scanVisible(posStart, startVoxel, targetEndX, targetEndY, targetEndZ)) {
            return true;
        }
        if ((dotselectors & 0x80) == 128 && this.scanVisible(posStart, startVoxel, targetEndX, targetBeginY, targetEndZ)) {
            return true;
        }
        double safeMiddleY = OcclusionCullingInstance.safeMiddleOffset(targetY, maxY);
        double safeMiddleZ = OcclusionCullingInstance.safeMiddleOffset(targetZ, maxZ);
        if ((dotselectors & 0x100) == 256 && this.scanVisible(posStart, startVoxel, targetBeginX, safeMiddleY, safeMiddleZ)) {
            return true;
        }
        double safeMiddleX = OcclusionCullingInstance.safeMiddleOffset(targetX, maxX);
        if ((dotselectors & 0x200) == 512 && this.scanVisible(posStart, startVoxel, safeMiddleX, targetBeginY, safeMiddleZ)) {
            return true;
        }
        if ((dotselectors & 0x400) == 1024 && this.scanVisible(posStart, startVoxel, safeMiddleX, safeMiddleY, targetBeginZ)) {
            return true;
        }
        if ((dotselectors & 0x800) == 2048 && this.scanVisible(posStart, startVoxel, targetEndX, safeMiddleY, safeMiddleZ)) {
            return true;
        }
        if ((dotselectors & 0x1000) == 4096 && this.scanVisible(posStart, startVoxel, safeMiddleX, targetEndY, safeMiddleZ)) {
            return true;
        }
        return (dotselectors & 0x2000) == 8192 && this.scanVisible(posStart, startVoxel, safeMiddleX, safeMiddleY, targetEndZ);
    }

    private boolean scanVisible(Vec3d posStart, Vec3i startVoxel, double x, double y, double z) {
        double dirX = x - posStart.x;
        double dirY = y - posStart.y;
        double dirZ = z - posStart.z;
        double dirLen = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        int steps = FacedOcclusionStepping.scanOccluded(this.provider, posStart, startVoxel, posStart.distanceSquared(x, y, z), dirX / dirLen, dirY / dirLen, dirZ / dirLen);
        if (steps < 0) {
            this.raySteps -= (long)steps;
            return true;
        }
        this.raySteps += (long)steps;
        return false;
    }

    public long getAndResetRaySteps() {
        long steps = this.raySteps;
        this.raySteps = 0L;
        return steps;
    }

    private static enum Relative {
        INSIDE,
        POSITIVE,
        NEGATIVE;


        public static Relative from(double min, double max, double pos) {
            if (max > pos && min > pos) {
                return POSITIVE;
            }
            if (min < pos && max < pos) {
                return NEGATIVE;
            }
            return INSIDE;
        }
    }
}

