/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.commands.builtin;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.pianoman911.playerculling.core.commands.PlayerCullingCommand;
import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.platform.command.MultiPlayerResolver;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSender;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSourceStack;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformEntity;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.TriState;

public final class PlayerCullingToggleCommand {
    private PlayerCullingToggleCommand() {
    }

    public static LiteralArgumentBuilder<PlatformCommandSourceStack> getNode(CullShip ship) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PlayerCullingCommand.literal("toggle").requires(ctx -> ctx.getSender().hasPermission("playerculling.command.toggle"))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)PlayerCullingCommand.literal("global").requires(ctx -> ctx.getSender().hasPermission("playerculling.command.toggle.global"))).executes(ctx -> PlayerCullingToggleCommand.executeGlobal(((PlatformCommandSourceStack)ctx.getSource()).getSender(), !ship.isCullingEnabled(), ship))).then(PlayerCullingCommand.argument("enabled", BoolArgumentType.bool()).executes(ctx -> PlayerCullingToggleCommand.executeGlobal(((PlatformCommandSourceStack)ctx.getSource()).getSender(), BoolArgumentType.getBool((CommandContext)ctx, (String)"enabled"), ship))))).then(((LiteralArgumentBuilder)PlayerCullingCommand.literal("player").requires(ctx -> ctx.getSender().hasPermission("playerculling.command.toggle.player"))).then(((RequiredArgumentBuilder)PlayerCullingCommand.argument("target", ship.getPlatform().getArgumentProvider().players()).executes(ctx -> PlayerCullingToggleCommand.executePlayer(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (Collection)((MultiPlayerResolver)ctx.getArgument("target", MultiPlayerResolver.class)).resolve((PlatformCommandSourceStack)ctx.getSource()), TriState.NOT_SET, ship))).then(PlayerCullingCommand.argument("enabled", BoolArgumentType.bool()).executes(ctx -> PlayerCullingToggleCommand.executePlayer(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (Collection)((MultiPlayerResolver)ctx.getArgument("target", MultiPlayerResolver.class)).resolve((PlatformCommandSourceStack)ctx.getSource()), TriState.byBoolean((boolean)BoolArgumentType.getBool((CommandContext)ctx, (String)"enabled")), ship)))));
    }

    private static int executeGlobal(PlatformCommandSender sender, boolean enabled, CullShip ship) {
        ship.toggleCulling(enabled);
        sender.sendMessage((Component)Component.text((String)("Culling is now " + (enabled ? "enabled" : "disabled")), (TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)));
        return 1;
    }

    private static int executePlayer(PlatformCommandSender sender, Collection<PlatformPlayer> target, TriState state, CullShip ship) {
        if (state == TriState.NOT_SET) {
            ArrayList<String> enabled = new ArrayList<String>();
            ArrayList<String> disabled = new ArrayList<String>();
            for (PlatformPlayer player : target) {
                CullPlayer cullPlayer = ship.getPlayer(player.getUniqueId());
                if (cullPlayer.isCullingEnabled()) {
                    cullPlayer.setCullingEnabled(false);
                    disabled.add(player.getName());
                    continue;
                }
                cullPlayer.setCullingEnabled(true);
                enabled.add(player.getName());
            }
            if (!enabled.isEmpty()) {
                sender.sendMessage((Component)Component.text((String)("Culling is now enabled for " + String.join((CharSequence)", ", enabled)), (TextColor)NamedTextColor.GREEN));
            }
            if (!disabled.isEmpty()) {
                sender.sendMessage((Component)Component.text((String)("Culling is now disabled for " + String.join((CharSequence)", ", disabled)), (TextColor)NamedTextColor.RED));
            }
        } else {
            boolean enabled = Boolean.TRUE.equals(state.toBoolean());
            String names = target.stream().map(PlatformEntity::getName).collect(Collectors.joining(", "));
            for (PlatformPlayer player : target) {
                CullPlayer cullPlayer = ship.getPlayer(player.getUniqueId());
                cullPlayer.setCullingEnabled(enabled);
            }
            sender.sendMessage((Component)Component.text((String)("Culling is now " + (enabled ? "enabled" : "disabled") + " for " + names), (TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)));
        }
        return 1;
    }
}

