/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.commands.builtin;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.pianoman911.playerculling.core.commands.PlayerCullingCommand;
import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.cache.OcclusionWorldCache;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSourceStack;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class PlayerCullingPerformanceCommand {
    private PlayerCullingPerformanceCommand() {
    }

    private static Component generatePerformanceInfo(CullShip ship, double ms) {
        return ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Performance: ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)String.format("%.2f", ms), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"ms - ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((int)ship.getPlayers().size(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" players - ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)ship.debugContainersFormat(), (TextColor)NamedTextColor.WHITE));
    }

    private static Component generateChunkCacheInfo(CullShip ship) {
        return ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Occlusion Cache: ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((int)OcclusionWorldCache.CACHE_EXECUTOR.getActiveCount(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((char)'/', (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((int)OcclusionWorldCache.CACHE_EXECUTOR.getLargestPoolSize(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" Threads - C/S: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((long)OcclusionWorldCache.CACHE_EXECUTOR.getCompletedTaskCount(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((char)'/', (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((int)OcclusionWorldCache.chunksStored(ship.getPlatform().getWorlds()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" chunks (", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)OcclusionWorldCache.formattedByteSize(ship.getPlatform().getWorlds()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.WHITE));
    }

    private static Component generateCulledPlayerInfo(float culledPerPlayer, int culledPlayers) {
        return ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Culled Players: ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)String.format("%.2f", Float.valueOf(culledPerPlayer * 100.0f)), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"% - ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((int)culledPlayers, (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" players", (TextColor)NamedTextColor.WHITE));
    }

    public static LiteralArgumentBuilder<PlatformCommandSourceStack> getNode(CullShip ship) {
        Set<PlatformPlayer> players = Collections.newSetFromMap(new WeakHashMap());
        BossBar culling = BossBar.bossBar((Component)Component.text((String)"-"), (float)1.0f, (BossBar.Color)BossBar.Color.GREEN, (BossBar.Overlay)BossBar.Overlay.NOTCHED_10);
        BossBar occlusion = BossBar.bossBar((Component)Component.text((String)"-"), (float)1.0f, (BossBar.Color)BossBar.Color.GREEN, (BossBar.Overlay)BossBar.Overlay.NOTCHED_10);
        BossBar culled = BossBar.bossBar((Component)Component.text((String)"-"), (float)1.0f, (BossBar.Color)BossBar.Color.GREEN, (BossBar.Overlay)BossBar.Overlay.NOTCHED_10);
        PlayerCullingPerformanceCommand.runPerformance(ship, players, culling, occlusion, culled);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)PlayerCullingCommand.literal("performance").requires(css -> css.getSender() instanceof PlatformPlayer && css.getSender().hasPermission("playerculling.command.performance"))).executes(ctx -> {
            PlatformPlayer sender = (PlatformPlayer)((PlatformCommandSourceStack)ctx.getSource()).getSender();
            if (players.contains(sender)) {
                players.remove(sender);
                sender.hideBossBar(culling);
                sender.hideBossBar(occlusion);
                sender.hideBossBar(culled);
                sender.sendMessage((Component)Component.text((String)"Disabled debug performance mode.", (TextColor)NamedTextColor.RED));
            } else {
                players.add(sender);
                sender.showBossBar(culling);
                sender.showBossBar(occlusion);
                sender.showBossBar(culled);
                sender.sendMessage((Component)Component.text((String)"Enabled debug performance mode.", (TextColor)NamedTextColor.GREEN));
            }
            return 1;
        });
    }

    private static void runPerformance(final CullShip ship, final Set<PlatformPlayer> players, final BossBar culling, final BossBar occlusion, final BossBar culled) {
        ship.getPlatform().runTaskRepeatingAsync(new Runnable(){
            private int ticks = 0;

            @Override
            public void run() {
                if (players.isEmpty()) {
                    return;
                }
                double ms = (double)ship.getLongestCullTime() / 1000000.0;
                if (++this.ticks % 20 == 0) {
                    culling.name(PlayerCullingPerformanceCommand.generatePerformanceInfo(ship, ms));
                    double progress = Math.max(0.0, Math.min(1.0, ms / 50.0));
                    if (progress > 1.0) {
                        culling.color(BossBar.Color.RED);
                    } else if (progress > 0.66) {
                        culling.color(BossBar.Color.YELLOW);
                    } else if (progress > 0.33) {
                        culling.color(BossBar.Color.GREEN);
                    } else {
                        culling.color(BossBar.Color.BLUE);
                    }
                    culling.progress((float)progress);
                    occlusion.name(PlayerCullingPerformanceCommand.generateChunkCacheInfo(ship));
                }
                Set<CullPlayer> cullPlayers = ship.getPlayers();
                int culledPlayers = 0;
                for (CullPlayer cullPlayer : cullPlayers) {
                    culledPlayers += cullPlayer.getHiddenCount();
                }
                float culledPerPlayer = cullPlayers.size() <= 1 ? 0.0f : (float)culledPlayers / ((float)cullPlayers.size() * ((float)cullPlayers.size() - 1.0f));
                culled.name(PlayerCullingPerformanceCommand.generateCulledPlayerInfo(culledPerPlayer, culledPlayers));
                culled.progress(Math.min(1.0f, culledPerPlayer));
            }
        }, 0L, 50L);
    }
}

