/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformpapernms12111;

import com.destroystokyo.paper.util.SneakyThrow;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.util.ReflectionUtil;
import de.pianoman911.playerculling.platformcommon.util.WaypointMode;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;

public class DelegatedWaypointManager
extends ServerWaypointManager {
    private static final MethodHandle SET_WAYPOINT_MANAGER = ReflectionUtil.getSetter(ServerLevel.class, ServerWaypointManager.class, 0);
    private static final MethodHandle GET_WAYPOINTS = ReflectionUtil.getGetter(ServerWaypointManager.class, Set.class, 0);
    private static final MethodHandle GET_PLAYERS = ReflectionUtil.getGetter(ServerWaypointManager.class, Set.class, 1);
    private static final MethodHandle GET_CONNECTIONS = ReflectionUtil.getGetter(ServerWaypointManager.class, Table.class, 0);
    private static final MethodHandle SET_WAYPOINTS = ReflectionUtil.getSetter(ServerWaypointManager.class, Set.class, 0);
    private static final MethodHandle SET_PLAYERS = ReflectionUtil.getSetter(ServerWaypointManager.class, Set.class, 1);
    private static final MethodHandle SET_CONNECTIONS = ReflectionUtil.getSetter(ServerWaypointManager.class, Table.class, 0);
    private static final MethodHandle CREATE_CONNECTION = ReflectionUtil.getMethod(ServerWaypointManager.class, MethodType.methodType(Void.TYPE, ServerPlayer.class, WaypointTransmitter.class), 0);
    private static final MethodHandle UPDATE_CONNECTION = ReflectionUtil.getMethod(ServerWaypointManager.class, MethodType.methodType(Void.TYPE, ServerPlayer.class, WaypointTransmitter.class, WaypointTransmitter.Connection.class), 0);
    private final ServerWaypointManager original;
    private final CullShip ship;

    public DelegatedWaypointManager(ServerWaypointManager original, CullShip ship) {
        this.original = original;
        this.ship = ship;
        DelegatedWaypointManager.copyState(original, this);
        ship.getConfig().addReloadHookAndRun(__ -> {
            this.breakAllConnections();
            for (WaypointTransmitter waypoint : this.this$waypoints()) {
                this.remakeConnections(waypoint);
            }
        });
    }

    public static void inject(ServerLevel level, CullShip ship) {
        ServerWaypointManager original = level.getWaypointManager();
        DelegatedWaypointManager delegated = new DelegatedWaypointManager(original, ship);
        try {
            SET_WAYPOINT_MANAGER.invoke(level, delegated);
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
        }
    }

    public static void uninject(ServerLevel level) {
        ServerWaypointManager delegated = level.getWaypointManager();
        if (!(delegated instanceof DelegatedWaypointManager)) {
            return;
        }
        DelegatedWaypointManager manager = (DelegatedWaypointManager)delegated;
        try {
            SET_WAYPOINT_MANAGER.invoke(level, manager.getOriginalModified());
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
        }
    }

    private static void copyState(ServerWaypointManager original, ServerWaypointManager delegated) {
        try {
            SET_WAYPOINTS.invoke(delegated, GET_WAYPOINTS.invoke(original));
            SET_PLAYERS.invoke(delegated, GET_PLAYERS.invoke(original));
            SET_CONNECTIONS.invoke(delegated, GET_CONNECTIONS.invoke(original));
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
        }
    }

    private static boolean isLocatorBarEnabledFor(ServerPlayer player) {
        return (Boolean)player.level().getGameRules().get(GameRules.LOCATOR_BAR);
    }

    public ServerWaypointManager getOriginalModified() {
        DelegatedWaypointManager.copyState(this, this.original);
        return this.original;
    }

    public void disconnectWaypoint(ServerPlayer player, WaypointTransmitter waypoint) {
        WaypointTransmitter.Connection connection = (WaypointTransmitter.Connection)this.this$connections().remove((Object)player, (Object)waypoint);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public void trackWaypoint(WaypointTransmitter waypoint) {
        if (!(waypoint instanceof ServerPlayer)) {
            super.trackWaypoint(waypoint);
            return;
        }
        this.this$waypoints().add(waypoint);
        for (ServerPlayer receiver : this.this$players()) {
            this.override$createConnection(receiver, (ServerPlayer)waypoint);
        }
    }

    public void updateWaypoint(WaypointTransmitter waypoint) {
        if (!this.this$waypoints().contains(waypoint)) {
            return;
        }
        if (!(waypoint instanceof ServerPlayer)) {
            super.updateWaypoint(waypoint);
            return;
        }
        ServerPlayer target = (ServerPlayer)waypoint;
        Map receiverConnections = Tables.transpose(this.this$connections()).row((Object)waypoint);
        Sets.SetView newReceivers = Sets.difference(this.this$players(), receiverConnections.keySet());
        for (Map.Entry entry : ImmutableSet.copyOf(receiverConnections.entrySet())) {
            this.override$updateConnection((ServerPlayer)entry.getKey(), target, (WaypointTransmitter.Connection)entry.getValue());
        }
        for (ServerPlayer receiver : newReceivers) {
            this.override$createConnection(receiver, target);
        }
    }

    public void addPlayer(ServerPlayer player) {
        this.this$players().add(player);
        for (WaypointTransmitter waypoint : this.this$waypoints()) {
            if (waypoint instanceof ServerPlayer) {
                this.override$createConnection(player, (ServerPlayer)waypoint);
                continue;
            }
            this.super$createConnection(player, waypoint);
        }
        if (player.isTransmittingWaypoint()) {
            this.trackWaypoint((WaypointTransmitter)player);
        }
    }

    public void updatePlayer(ServerPlayer player) {
        Map receiverConnections = this.this$connections().row((Object)player);
        Sets.SetView newWaypoints = Sets.difference(this.this$waypoints(), receiverConnections.keySet());
        for (Map.Entry entry : ImmutableSet.copyOf(receiverConnections.entrySet())) {
            Object k = entry.getKey();
            if (k instanceof ServerPlayer) {
                ServerPlayer target = (ServerPlayer)k;
                this.override$updateConnection(player, target, (WaypointTransmitter.Connection)entry.getValue());
                continue;
            }
            this.super$updateConnection(player, (WaypointTransmitter)entry.getKey(), (WaypointTransmitter.Connection)entry.getValue());
        }
        for (WaypointTransmitter waypoint : newWaypoints) {
            if (waypoint instanceof ServerPlayer) {
                this.override$createConnection(player, (ServerPlayer)waypoint);
                continue;
            }
            this.super$createConnection(player, waypoint);
        }
    }

    public void remakeConnections(WaypointTransmitter waypoint) {
        if (!(waypoint instanceof ServerPlayer)) {
            super.remakeConnections(waypoint);
            return;
        }
        for (ServerPlayer receiver : this.this$players()) {
            this.override$createConnection(receiver, (ServerPlayer)waypoint);
        }
    }

    protected Set<WaypointTransmitter> this$waypoints() {
        try {
            return GET_WAYPOINTS.invoke(this);
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
            return null;
        }
    }

    protected Set<ServerPlayer> this$players() {
        try {
            return GET_PLAYERS.invoke(this);
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
            return null;
        }
    }

    protected Table<ServerPlayer, WaypointTransmitter, WaypointTransmitter.Connection> this$connections() {
        try {
            return GET_CONNECTIONS.invoke(this);
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
            return null;
        }
    }

    protected void super$createConnection(ServerPlayer player, WaypointTransmitter waypoint) {
        try {
            CREATE_CONNECTION.invoke(this.original, player, waypoint);
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
        }
    }

    protected void super$updateConnection(ServerPlayer player, WaypointTransmitter waypoint, WaypointTransmitter.Connection connection) {
        try {
            UPDATE_CONNECTION.invoke(this.original, player, waypoint, connection);
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
        }
    }

    protected void override$createConnection(ServerPlayer player, ServerPlayer waypoint) {
        if (player != waypoint && DelegatedWaypointManager.isLocatorBarEnabledFor(player)) {
            this.handleUpdateWaypointConnection(player, waypoint);
        }
    }

    protected void override$updateConnection(ServerPlayer player, ServerPlayer waypoint, WaypointTransmitter.Connection connection) {
        if (player == waypoint || !DelegatedWaypointManager.isLocatorBarEnabledFor(player)) {
            return;
        }
        if (this.ship.getConfig().getDelegate().waypointMode == WaypointMode.CULLED_AZIMUTH) {
            CullPlayer cullPlayer = this.ship.getPlayer(player.getUUID());
            if (cullPlayer == null) {
                return;
            }
            if (cullPlayer.isHidden(waypoint.getUUID())) {
                this.disconnectWaypoint(player, (WaypointTransmitter)waypoint);
                return;
            }
        }
        if (WaypointTransmitter.doesSourceIgnoreReceiver((LivingEntity)waypoint, (ServerPlayer)player)) {
            this.handleUpdateWaypointConnection(player, waypoint);
        } else {
            connection.update();
        }
    }

    protected void handleUpdateWaypointConnection(ServerPlayer player, ServerPlayer waypoint) {
        WaypointTransmitter.Connection connection = switch (this.ship.getConfig().getDelegate().waypointMode) {
            case WaypointMode.CULLED_AZIMUTH -> {
                CullPlayer cullPlayer = this.ship.getPlayer(player.getUUID());
                if (cullPlayer == null || cullPlayer.isHidden(waypoint.getUUID())) {
                    yield null;
                }
            }
            case WaypointMode.AZIMUTH -> new WaypointTransmitter.EntityAzimuthConnection((LivingEntity)waypoint, new Waypoint.Icon().cloneAndAssignStyle((LivingEntity)waypoint), player);
            case WaypointMode.VANILLA -> waypoint.makeWaypointConnectionWith(player).orElse(null);
            case WaypointMode.HIDDEN -> null;
            default -> throw new AssertionError();
        };
        if (connection == null) {
            WaypointTransmitter.Connection removed = (WaypointTransmitter.Connection)this.this$connections().remove((Object)player, (Object)waypoint);
            if (removed != null) {
                removed.disconnect();
            }
        } else {
            this.this$connections().put((Object)player, (Object)waypoint, (Object)connection);
            connection.connect();
        }
    }
}

