/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformcommon.util;

import de.pianoman911.playerculling.platformcommon.util.StringUtil;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public final class OcclusionMappings {
    public static final boolean[] EMPTY_CUBE = new boolean[]{false, false, false, false, false, false, false, false};
    public static final boolean[] FULL_CUBE = new boolean[]{true, true, true, true, true, true, true, true};
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PlayerCulling");
    private final long[] occlusionMappings;
    private final int maxSize;
    private boolean built;

    public OcclusionMappings(int size) {
        this.occlusionMappings = new long[(int)Math.ceil((double)size / 8.0)];
        this.maxSize = size;
    }

    public boolean hasVoxel(int blockId, int index) {
        long voxelData = this.occlusionMappings[blockId >> 3];
        long mask = 1L << (int)((long)index + (((long)blockId & 7L) << 3));
        return (voxelData & mask) != 0L;
    }

    public void lazyBuildCache(Function<Integer, boolean[]> mapper) {
        if (this.built) {
            return;
        }
        long start = System.nanoTime();
        this.buildCache(mapper);
        long time = System.nanoTime() - start;
        long bytes = 8L * (long)this.occlusionMappings.length;
        LOGGER.info("Occlusion mappings cache built with {} voxels and {} entries ({}) in {}ms", new Object[]{this.maxSize, this.occlusionMappings.length, StringUtil.toNumInUnits(bytes), (double)time / 1000000.0});
    }

    public void buildCache(Function<Integer, boolean[]> mapper) {
        int maxLength = this.occlusionMappings.length;
        for (int i = 0; i < maxLength; i += 8) {
            long bits = 0L;
            for (int j = i + 8 - 1; j >= i; --j) {
                if (j >= this.maxSize) {
                    bits <<= 8;
                    continue;
                }
                boolean[] bools = mapper.apply(j);
                for (int k = bools.length - 1; k >= 0; --k) {
                    bits <<= 1;
                    if (!bools[k]) continue;
                    bits |= 1L;
                }
            }
            this.occlusionMappings[i >> 3] = bits;
        }
        this.built = true;
    }

    public boolean isBuilt() {
        return this.built;
    }
}

