/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformcommon.util;

import java.util.Arrays;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class FastStack<T> {
    private static final int GROW_RATE = 3;
    private int capacity;
    private int index;
    private T[] stack;

    public FastStack(int initialCapacity) {
        this.capacity = initialCapacity;
        this.stack = new Object[initialCapacity];
    }

    public void push(T o) {
        this.stack[this.index++] = o;
    }

    public @Nullable T pop() {
        if (this.index == 0) {
            return null;
        }
        return this.stack[--this.index];
    }

    public boolean isEmpty() {
        return this.index == 0;
    }

    public boolean hasEntries() {
        return this.index > 0;
    }

    public void grow(int targetIndex) {
        if (this.capacity > targetIndex) {
            return;
        }
        this.capacity = targetIndex + 3;
        this.stack = Arrays.copyOf(this.stack, this.capacity);
    }
}

