/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.util;

import de.pianoman911.playerculling.core.util.CameraMode;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import de.pianoman911.playerculling.platformcommon.vector.Vec3d;

public final class ClientsideUtil {
    public static final float EPSILON = 1.0E-6f;

    public static void addPlayerViewOffset(Vec3d vec, PlatformPlayer player, CameraMode mode, double modifier) {
        double yaw = player.getYaw();
        double pitch = player.getPitch();
        if (mode == CameraMode.THIRD_PERSON_BACK) {
            yaw += 180.0;
            pitch *= -1.0;
        }
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        double x = -Math.sin(yaw) * Math.cos(pitch);
        double y = -Math.sin(pitch);
        double z = Math.cos(yaw) * Math.cos(pitch);
        vec.x += x * modifier;
        vec.y += y * modifier;
        vec.z += z * modifier;
    }

    public static void addPlayerViewOffset(Vec3d vec, PlatformPlayer player, CameraMode mode) {
        ClientsideUtil.addPlayerViewOffset(vec, player, mode, ClientsideUtil.maxZoom(player, mode));
    }

    private static double maxZoom(PlatformPlayer player, CameraMode mode) {
        Vec3d ray;
        double value = 4.0;
        Vec3d pos = player.getEyePosition();
        Vec3d dir = player.getDirection();
        switch (mode) {
            default: {
                throw new MatchException(null, null);
            }
            case THIRD_PERSON_BACK: {
                Vec3d vec3d = player.getWorld().rayTraceBlocks(pos, dir.mul(-1.0), 4.0);
                break;
            }
            case THIRD_PERSON_FRONT: {
                Vec3d vec3d = player.getWorld().rayTraceBlocks(pos, dir, 4.0);
                break;
            }
            case FIRST_PERSON: {
                Vec3d vec3d = ray = null;
            }
        }
        if (ray != null) {
            value = ray.distance(pos) - (double)1.0E-6f;
        }
        return value;
    }
}

