/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.commands.builtin;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.pianoman911.playerculling.core.commands.PlayerCullingCommand;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.AABB;
import de.pianoman911.playerculling.platformcommon.cache.OcclusionChunkCache;
import de.pianoman911.playerculling.platformcommon.platform.command.BlockPosResolver;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSender;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSourceStack;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformLivingEntity;
import de.pianoman911.playerculling.platformcommon.util.DebugUtil;
import de.pianoman911.playerculling.platformcommon.vector.Vec3i;
import net.kyori.adventure.text.Component;

public final class PlayerCullingBlockDebugCommand {
    private PlayerCullingBlockDebugCommand() {
    }

    public static LiteralArgumentBuilder<PlatformCommandSourceStack> getNode(CullShip ship) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PlayerCullingCommand.literal("blockdebug").requires(ctx -> ctx.getExecutor() instanceof PlatformLivingEntity && ctx.getSender().hasPermission("playerculling.command.blockdebug"))).executes(ctx -> PlayerCullingBlockDebugCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (PlatformLivingEntity)((PlatformCommandSourceStack)ctx.getSource()).getExecutor(), false, ((PlatformLivingEntity)((PlatformCommandSourceStack)ctx.getSource()).getExecutor()).getTargetBlock(100)))).then(PlayerCullingCommand.argument("block", ship.getPlatform().getArgumentProvider().blockPos()).executes(ctx -> PlayerCullingBlockDebugCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (PlatformLivingEntity)((PlatformCommandSourceStack)ctx.getSource()).getExecutor(), false, (Vec3i)((BlockPosResolver)ctx.getArgument("block", BlockPosResolver.class)).resolve((PlatformCommandSourceStack)ctx.getSource()))))).then(((RequiredArgumentBuilder)PlayerCullingCommand.argument("raw", BoolArgumentType.bool()).executes(ctx -> PlayerCullingBlockDebugCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (PlatformLivingEntity)((PlatformCommandSourceStack)ctx.getSource()).getExecutor(), BoolArgumentType.getBool((CommandContext)ctx, (String)"raw"), ((PlatformLivingEntity)((PlatformCommandSourceStack)ctx.getSource()).getExecutor()).getTargetBlock(100)))).then(PlayerCullingCommand.argument("block", ship.getPlatform().getArgumentProvider().blockPos()).executes(ctx -> PlayerCullingBlockDebugCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (PlatformLivingEntity)((PlatformCommandSourceStack)ctx.getSource()).getExecutor(), BoolArgumentType.getBool((CommandContext)ctx, (String)"raw"), (Vec3i)((BlockPosResolver)ctx.getArgument("block", BlockPosResolver.class)).resolve((PlatformCommandSourceStack)ctx.getSource())))));
    }

    private static int execute(PlatformCommandSender sender, PlatformLivingEntity executor, boolean raw, Vec3i block) {
        OcclusionChunkCache chunk = executor.getWorld().getOcclusionWorldCache().chunk(block.getX() >> 4, block.getZ() >> 4);
        double x = block.getX();
        double y = block.getY();
        double z = block.getZ();
        sender.sendMessage((Component)Component.text((String)"---{ Block Debug }---"));
        sender.sendMessage((Component)Component.text((String)String.format("Block: %f %f %f", x, y, z)));
        if (raw) {
            sender.sendMessage((Component)Component.text((String)"---Raw---"));
            boolean[] shapes = chunk.isOpaqueFullBlock((int)x, (int)y, (int)z);
            for (int i = 0; i < 8; ++i) {
                executor.sendMessage((Component)Component.text((String)String.format("%d: %s", i, shapes[i])));
            }
        } else {
            sender.sendMessage((Component)Component.text((String)"---Occlusion Cache---"));
            for (int i = 0; i < 8; ++i) {
                double offX = (double)(i & 1) * 0.5;
                double offY = (double)(i >> 1 & 1) * 0.5;
                double offZ = (double)(i >> 2 & 1) * 0.5;
                executor.sendMessage((Component)Component.text((String)String.format("%d: %s X: %f;%f;%f", i, chunk.isOccluded(x + offX, y + offY, z + offZ), offX, offY, offZ)));
            }
        }
        executor.sendMessage((Component)Component.text((String)"---------------------"));
        DebugUtil.drawBoundingBox(executor.getWorld(), new AABB(x, y, z, x + 1.0, y + 1.0, z + 1.0));
        return 1;
    }
}

