/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformpaper.platform;

import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import de.pianoman911.playerculling.platformcommon.vector.Vec3d;
import de.pianoman911.playerculling.platformpaper.platform.PaperLivingEntity;
import de.pianoman911.playerculling.platformpaper.platform.PaperPlatform;
import net.kyori.adventure.bossbar.BossBar;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperPlayer
extends PaperLivingEntity<Player>
implements PlatformPlayer {
    private final PaperPlatform platform;

    public PaperPlayer(PaperPlatform platform, Player player) {
        super(platform, player);
        this.platform = platform;
    }

    @Override
    public boolean shouldPreventCulling() {
        return ((Player)this.getDelegate()).isDead();
    }

    @Override
    public boolean isSpectator() {
        return this.platform.getNmsAdapter().isSpectator((Player)this.getDelegate());
    }

    @Override
    public int getTrackingDistance() {
        return ((Player)this.getDelegate()).getClientViewDistance() << 4;
    }

    @Override
    public Vec3d getDirection() {
        Vector dir = ((Player)this.getDelegate()).getLocation().getDirection();
        return new Vec3d(dir.getX(), dir.getY(), dir.getZ());
    }

    @Override
    public Vec3d getEyePosition() {
        Location loc = ((Player)this.getDelegate()).getEyeLocation();
        return new Vec3d(loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public double getYaw() {
        return ((Player)this.getDelegate()).getLocation().getYaw();
    }

    @Override
    public double getPitch() {
        return ((Player)this.getDelegate()).getLocation().getPitch();
    }

    @Override
    public long getBlindnessTicks() {
        PotionEffect blindnessEffect = ((Player)this.getDelegate()).getPotionEffect(PotionEffectType.BLINDNESS);
        if (blindnessEffect != null) {
            return blindnessEffect.getDuration();
        }
        return -1L;
    }

    @Override
    public boolean isGlowing() {
        return ((Player)this.getDelegate()).isGlowing();
    }

    @Override
    public long getDarknessTicks() {
        PotionEffect darknessEffect = ((Player)this.getDelegate()).getPotionEffect(PotionEffectType.DARKNESS);
        if (darknessEffect != null) {
            return darknessEffect.getDuration();
        }
        return -1L;
    }

    @Override
    public boolean canSeeNameTag(PlatformPlayer targetPlayer) {
        Player target = (Player)((PaperPlayer)targetPlayer).getDelegate();
        return this.platform.getNmsAdapter().canSeeNametag((Player)this.getDelegate(), target);
    }

    @Override
    public boolean isSneaking() {
        return ((Player)this.getDelegate()).isSneaking();
    }

    @Override
    public boolean isOnline() {
        return ((Player)this.getDelegate()).isConnected();
    }

    @Override
    public void showBossBar(BossBar bossBar) {
        ((Player)this.getDelegate()).showBossBar(bossBar);
    }

    @Override
    public void hideBossBar(BossBar bossBar) {
        ((Player)this.getDelegate()).hideBossBar(bossBar);
    }

    @Override
    public void addDirectPairing(PlatformPlayer ... players) {
        this.platform.getNmsAdapter().addPairing(this, players);
    }
}

