/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformpaper.platform;

import de.pianoman911.playerculling.api.PlayerCullingApi;
import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.platform.IPlatform;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformArgumentProvider;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import de.pianoman911.playerculling.platformcommon.platform.world.PlatformWorld;
import de.pianoman911.playerculling.platformcommon.util.OcclusionMappings;
import de.pianoman911.playerculling.platformpaper.PlayerCullingPlugin;
import de.pianoman911.playerculling.platformpaper.platform.PaperArgumentsProvider;
import de.pianoman911.playerculling.platformpaper.platform.PaperCommandSender;
import de.pianoman911.playerculling.platformpaper.platform.PaperCommandSourceStack;
import de.pianoman911.playerculling.platformpaper.platform.PaperPlayer;
import de.pianoman911.playerculling.platformpaper.platform.PaperWorld;
import de.pianoman911.playerculling.platformpaper.util.PaperNmsAdapter;
import de.pianoman911.playerculling.platformpaper.util.ServicesUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperPlatform
implements IPlatform {
    protected final Map<Player, PaperPlayer> playerMap = new WeakHashMap<Player, PaperPlayer>();
    private final Map<UUID, PaperWorld> worldMap = new HashMap<UUID, PaperWorld>();
    private final PaperArgumentsProvider argumentsProvider = new PaperArgumentsProvider(this);
    private final Int2ObjectMap<ScheduledTask> taskMap = new Int2ObjectArrayMap();
    private final AtomicInteger taskIdCounter = new AtomicInteger(0);
    private final OcclusionMappings occlusionMappings;
    private final PlayerCullingPlugin plugin;
    private final PaperNmsAdapter nmsAdapter;
    private long currentTick;

    public PaperPlatform(PlayerCullingPlugin plugin) {
        this.plugin = plugin;
        this.nmsAdapter = ServicesUtil.loadService(PaperNmsAdapter.class);
        this.occlusionMappings = new OcclusionMappings(this.nmsAdapter.getBlockStateCount() * 8);
    }

    @Override
    public void tick() {
        ++this.currentTick;
    }

    @Override
    public long getCurrentTick() {
        return this.currentTick;
    }

    @Override
    public PlatformWorld getWorld(Key key) {
        World world = Bukkit.getWorld((Key)key);
        if (world == null) {
            throw new IllegalArgumentException("Can't find world with name " + String.valueOf(key));
        }
        return this.provideWorld(world);
    }

    @Override
    public @Unmodifiable Collection<PlatformWorld> getWorlds() {
        return Collections.unmodifiableCollection(this.worldMap.values());
    }

    @Override
    public PlatformPlayer getPlayer(UUID playerId) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            throw new IllegalArgumentException("Can't find player with uuid " + String.valueOf(playerId));
        }
        return this.providePlayer(player);
    }

    public @Unmodifiable Set<PaperPlayer> getPlayers() {
        HashSet<PaperPlayer> players = new HashSet<PaperPlayer>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            players.add(this.providePlayer(player));
        }
        return Collections.unmodifiableSet(players);
    }

    @Override
    public int runTaskLaterAsync(Runnable runnable, long delay) {
        ScheduledTask scheduledTask = this.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)this.plugin, __ -> runnable.run(), delay, TimeUnit.MILLISECONDS);
        int taskId = this.taskIdCounter.getAndIncrement();
        this.taskMap.put(taskId, (Object)scheduledTask);
        return taskId;
    }

    @Override
    public int runTaskRepeatingAsync(Runnable runnable, long delay, long period) {
        ScheduledTask scheduledTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, __ -> runnable.run(), delay, period, TimeUnit.MILLISECONDS);
        int taskId = this.taskIdCounter.getAndIncrement();
        this.taskMap.put(taskId, (Object)scheduledTask);
        return taskId;
    }

    @Override
    public void cancelTask(int taskId) {
        ScheduledTask task = (ScheduledTask)this.taskMap.remove(taskId);
        if (task != null) {
            task.cancel();
        }
    }

    @Override
    public void registerApi(PlayerCullingApi api) {
        this.plugin.getServer().getServicesManager().register(PlayerCullingApi.class, (Object)api, (Plugin)this.plugin, ServicePriority.Normal);
    }

    @Override
    public Path getDataFolder() {
        return this.plugin.getDataPath();
    }

    @Override
    public PlatformArgumentProvider getArgumentProvider() {
        return this.argumentsProvider;
    }

    public PaperWorld provideWorld(World world) {
        return this.worldMap.computeIfAbsent(world.getUID(), id -> {
            PaperWorld paperWorld = new PaperWorld(world, this);
            this.nmsAdapter.lazyBuildOcclusionMappings(this.occlusionMappings, paperWorld);
            return paperWorld;
        });
    }

    public PaperPlayer providePlayer(Player player) {
        return this.playerMap.computeIfAbsent(player, id -> new PaperPlayer(this, (Player)id));
    }

    public <I extends CommandSender, T extends PaperCommandSender<I>> T provideCommandSender(I sender) {
        if (sender instanceof Player) {
            return (T)this.providePlayer((Player)sender);
        }
        return (T)new PaperCommandSender<I>(this, sender);
    }

    public PaperCommandSourceStack provideCommandSourceStack(CommandSourceStack source) {
        return new PaperCommandSourceStack(this, source);
    }

    public void invalidatePlayer(Player player) {
        this.playerMap.remove(player);
        CullShip ship = this.plugin.getCullShip();
        ship.removePlayer(player.getUniqueId());
        for (CullPlayer cullPlayer : ship.getPlayers()) {
            cullPlayer.invalidateOther(player.getUniqueId());
        }
    }

    public @Unmodifiable Collection<PaperWorld> getPaperWorlds() {
        return Collections.unmodifiableCollection(this.worldMap.values());
    }

    public PlayerCullingPlugin getPlugin() {
        return this.plugin;
    }

    public PaperNmsAdapter getNmsAdapter() {
        return this.nmsAdapter;
    }

    public OcclusionMappings getOcclusionMappings() {
        return this.occlusionMappings;
    }
}

