/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformfolianms1216;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformfolianms1216.DelegatedTrackedEntity;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTrackerListener
implements Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PlayerCulling");
    private final CullShip ship;
    private final Set<Player> players = Collections.newSetFromMap(new WeakHashMap());

    public EntityTrackerListener(CullShip ship) {
        this.ship = ship;
    }

    @EventHandler
    public void onAdd(PlayerTrackEntityEvent event) {
        if (this.players.add(event.getPlayer())) {
            try {
                DelegatedTrackedEntity.injectPlayer(event.getPlayer(), this.ship);
            }
            catch (Throwable exception) {
                LOGGER.error("Failed to inject player into entity tracker", exception);
                event.getPlayer().kick((Component)Component.text((String)"[PlayerCulling] Failed to inject player into entity tracker"));
            }
        }
    }

    @EventHandler
    public void onSwitchWorld(EntityAddToWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.players.remove(player);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.players.remove(player);
    }
}

