/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformcommon.util;

import de.pianoman911.playerculling.platformcommon.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.LongFunction;
import org.jetbrains.annotations.UnknownNullability;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ConcurrentLongCache<V>
implements Iterable<V> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    private static final int TREEIFY_THRESHOLD = 8;
    private static final int UNTREEIFY_THRESHOLD = 6;
    private static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static final int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = 65535;
    private static final int RESIZE_STAMP_SHIFT = 16;
    private static final int MOVED = -1;
    private static final int TREEBIN = -2;
    private static final int RESERVED = -3;
    private static final int HASH_BITS = Integer.MAX_VALUE;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final VarHandle NODE_ARRAY_ELEMENT;
    private static final VarHandle TREEBIN_WAITERTHREAD;
    private static final MethodHandle GET_THREAD_THREAD_LOCAL_RANDOM_PROBE;
    private static final MethodHandle THREAD_LOCAL_RANDOM_LOCAL_INIT;
    private static final MethodHandle THREAD_LOCAL_RANDOM_ADVANCE_PROBE;
    private final LongFunction<V> ctor;
    private volatile @Nullable Node<V> @Nullable [] table;
    private volatile @Nullable Node<V> @Nullable [] nextTable;
    private final AtomicLong baseCount = new AtomicLong();
    private final AtomicInteger sizeCtl = new AtomicInteger();
    private final AtomicInteger transferIndex = new AtomicInteger();
    private final AtomicInteger cellsBusy = new AtomicInteger();
    private volatile @Nullable CounterCell @Nullable [] counterCells;

    public ConcurrentLongCache(LongFunction<V> ctor) {
        this.ctor = ctor;
    }

    private static int saferHashCode(long l) {
        return 1664525 * (int)(l >>> 32) + 1013904223 ^ 1664525 * ((int)l ^ 0xDEADBEEF) + 1013904223;
    }

    private static int getThreadLocalRandomProbe() {
        try {
            return GET_THREAD_THREAD_LOCAL_RANDOM_PROBE.invoke(Thread.currentThread());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static int spread(int hash) {
        return (hash ^ hash >>> 16) & Integer.MAX_VALUE;
    }

    private static int tableSizeFor(int c) {
        int n = -1 >>> Integer.numberOfLeadingZeros(c - 1);
        return n < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private static int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 0x8000;
    }

    private static <V> Node<V> untreeify(@Nullable Node<V> b) {
        Node hd = null;
        Node tl = null;
        Node<V> q = b;
        while (q != null) {
            Node p = new Node(q.hash, q.key, q.val);
            if (tl == null) {
                hd = p;
            } else {
                tl.next = p;
            }
            tl = p;
            q = q.next;
        }
        return hd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void treeifyBin(@Nullable Node<V> @Nullable [] tab, int index) {
        if (tab != null) {
            int n = tab.length;
            if (n < 64) {
                this.tryPresize(n << 1);
            } else {
                Node b = NODE_ARRAY_ELEMENT.getAcquire(tab, index);
                if (b != null && b.hash >= 0) {
                    Node node = b;
                    synchronized (node) {
                        if (NODE_ARRAY_ELEMENT.getAcquire(tab, index) == b) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node e = b;
                            while (e != null) {
                                TreeNode p = new TreeNode(e.hash, e.key, e.val, null, null);
                                p.prev = tl;
                                if (p.prev == null) {
                                    hd = p;
                                } else {
                                    tl.next = p;
                                }
                                tl = p;
                                e = e.next;
                            }
                            NODE_ARRAY_ELEMENT.setRelease(tab, index, new TreeBin(hd));
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final @Nullable Node<V>[] initTable() {
        Node<V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl.get();
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (this.sizeCtl.compareAndSet(sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    @Nullable Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl.set(sc);
            }
        }
        return tab;
    }

    private final void addCount(long x, int check) {
        long s;
        long b;
        CounterCell[] cs = this.counterCells;
        if (this.counterCells != null || !this.baseCount.compareAndSet(b = this.baseCount.get(), s = b + x)) {
            long v;
            CounterCell c;
            int m;
            boolean uncontended = true;
            if (cs == null || (m = cs.length - 1) < 0 || (c = cs[ConcurrentLongCache.getThreadLocalRandomProbe() & m]) == null || !(uncontended = c.value.compareAndSet(v = c.value.get(), v + x))) {
                this.fullAddCount(x, uncontended);
                return;
            }
            if (check <= 1) {
                return;
            }
            s = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl.get())) {
                int n;
                Node<V>[] tab = this.table;
                if (this.table == null || (n = tab.length) >= 0x40000000) break;
                int rs = ConcurrentLongCache.resizeStamp(n) << 16;
                if (sc < 0) {
                    if (sc == rs + 65535 || sc == rs + 1) break;
                    Node<V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex.get() <= 0) break;
                    if (this.sizeCtl.compareAndSet(sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (this.sizeCtl.compareAndSet(sc, rs + 2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    private final @Nullable Node<V> @Nullable [] helpTransfer(@Nullable Node<V> @Nullable [] tab, Node<V> f) {
        if (tab != null && f instanceof ForwardingNode) {
            Node<V>[] nextTab = ((ForwardingNode)f).nextTable;
            if (((ForwardingNode)f).nextTable != null) {
                int sc;
                int rs = ConcurrentLongCache.resizeStamp(tab.length) << 16;
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl.get()) < 0 && sc != rs + 65535 && sc != rs + 1 && this.transferIndex.get() > 0) {
                    if (!this.sizeCtl.compareAndSet(sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : ConcurrentLongCache.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl.get()) >= 0) {
            int rs;
            int n2;
            @Nullable Node<V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                n2 = Math.max(sc, c);
                if (!this.sizeCtl.compareAndSet(sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    @Nullable Node[] nt = new Node[n2];
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl.set(sc);
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table || !this.sizeCtl.compareAndSet(sc, ((rs = ConcurrentLongCache.resizeStamp(n2)) << 16) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transfer(@Nullable Node<V>[] tab, @Nullable Node<V> @Nullable [] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl.set(Integer.MAX_VALUE);
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex.set(n);
        }
        int nextn = nextTab.length;
        ForwardingNode<V> fwd = new ForwardingNode<V>(nextTab);
        boolean advance = true;
        boolean finishing = false;
        int i = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex.get();
                if (nextIndex <= 0) {
                    i = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!this.transferIndex.compareAndSet(nextIndex, nextBound)) continue;
                bound = nextBound;
                i = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i < 0 || i >= n || i + n >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl.set((n << 1) - (n >>> 1));
                    return;
                }
                int sc = this.sizeCtl.get();
                if (!this.sizeCtl.compareAndSet(sc, sc - 1)) continue;
                if (sc - 2 != ConcurrentLongCache.resizeStamp(n) << 16) {
                    return;
                }
                advance = true;
                finishing = true;
                i = n;
                continue;
            }
            TreeBin f = NODE_ARRAY_ELEMENT.getAcquire(tab, i);
            if (f == null) {
                advance = NODE_ARRAY_ELEMENT.compareAndSet(tab, i, null, fwd);
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (NODE_ARRAY_ELEMENT.getAcquire(tab, i) == f) {
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n;
                        TreeBin lastRun = f;
                        Node p = f.next;
                        while (p != null) {
                            int b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p = f;
                        while (p != lastRun) {
                            int ph = p.hash;
                            long pk = p.key;
                            Object pv = p.val;
                            if ((ph & n) == 0) {
                                ln = new Node(ph, pk, pv, ln);
                            } else {
                                hn = new Node(ph, pk, pv, hn);
                            }
                            p = p.next;
                        }
                        NODE_ARRAY_ELEMENT.setRelease(nextTab, i, ln);
                        NODE_ARRAY_ELEMENT.setRelease(nextTab, i + n, hn);
                        NODE_ARRAY_ELEMENT.setRelease(tab, i, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t = f;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t.first;
                        while (e != null) {
                            int h = e.hash;
                            TreeNode p = new TreeNode(h, e.key, e.val, null, null);
                            if ((h & n) == 0) {
                                p.prev = loTail;
                                if (p.prev == null) {
                                    lo = p;
                                } else {
                                    loTail.next = p;
                                }
                                loTail = p;
                                ++lc;
                            } else {
                                p.prev = hiTail;
                                if (p.prev == null) {
                                    hi = p;
                                } else {
                                    hiTail.next = p;
                                }
                                hiTail = p;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? ConcurrentLongCache.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo) : t);
                        hn = hc <= 6 ? ConcurrentLongCache.untreeify(hi) : (lc != 0 ? new TreeBin(hi) : t);
                        NODE_ARRAY_ELEMENT.setRelease(nextTab, i, ln);
                        NODE_ARRAY_ELEMENT.setRelease(nextTab, i + n, hn);
                        NODE_ARRAY_ELEMENT.setRelease(tab, i, fwd);
                        advance = true;
                    } else if (f instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
        }
    }

    private final long sumCount() {
        @Nullable CounterCell[] cs = this.counterCells;
        long sum = this.baseCount.get();
        if (cs != null) {
            for (CounterCell c : cs) {
                if (c == null) continue;
                sum += c.value.get();
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fullAddCount(long x, boolean wasUncontended) {
        int h = ConcurrentLongCache.getThreadLocalRandomProbe();
        if (h == 0) {
            try {
                THREAD_LOCAL_RANDOM_LOCAL_INIT.invoke();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            h = ConcurrentLongCache.getThreadLocalRandomProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] cs = this.counterCells;
            if (this.counterCells != null && (n = cs.length) > 0) {
                CounterCell c = cs[n - 1 & h];
                if (c == null) {
                    if (this.cellsBusy.get() == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.cellsBusy.get() == 0 && this.cellsBusy.compareAndSet(0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy.set(0);
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = c.value.get();
                    if (c.value.compareAndSet(v, v + x)) return;
                    if (this.counterCells != cs || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy.get() == 0 && this.cellsBusy.compareAndSet(0, 1)) {
                        try {
                            if (this.counterCells == cs) {
                                this.counterCells = Arrays.copyOf(cs, n << 1);
                            }
                        }
                        finally {
                            this.cellsBusy.set(0);
                        }
                        collide = false;
                        continue;
                    }
                }
                try {
                    h = THREAD_LOCAL_RANDOM_ADVANCE_PROBE.invoke(h);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            if (this.cellsBusy.get() == 0 && this.counterCells == cs && this.cellsBusy.compareAndSet(0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == cs) {
                        @Nullable CounterCell[] rs = new CounterCell[2];
                        rs[h & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy.set(0);
                }
                if (!init) continue;
                return;
            }
            v = this.baseCount.get();
            if (this.baseCount.compareAndSet(v, v + x)) return;
        }
    }

    public int size() {
        long n = this.sumCount();
        if (n < 0L) {
            return 0;
        }
        if (n > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)n;
    }

    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    public @Nullable V get(long key) {
        Node e;
        int n;
        int h = ConcurrentLongCache.spread(ConcurrentLongCache.saferHashCode(key));
        @Nullable Node[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = NODE_ARRAY_ELEMENT.getAcquire(tab, n - 1 & h)) != null) {
            int eh = e.hash;
            if (eh == h) {
                if (e.key == key) {
                    return e.val;
                }
            } else if (eh < 0) {
                Node p = e.find(h, key);
                return p != null ? (V)p.val : null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || e.key != key) continue;
                return e.val;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrCompute(long key) {
        int binCount;
        Object val;
        block29: {
            boolean added;
            int i;
            int h = ConcurrentLongCache.spread(ConcurrentLongCache.saferHashCode(key));
            val = null;
            binCount = 0;
            @Nullable Node[] tab = this.table;
            while (true) {
                Object fv;
                Node node;
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & h;
                Node f = NODE_ARRAY_ELEMENT.getAcquire(tab, i);
                if (f == null) {
                    ReservationNode r;
                    node = r = new ReservationNode();
                    synchronized (node) {
                        if (NODE_ARRAY_ELEMENT.compareAndSet(tab, i, null, r)) {
                            binCount = 1;
                            Node<Object> node2 = null;
                            try {
                                val = this.ctor.apply(key);
                                node2 = new Node<Object>(h, key, val);
                            }
                            finally {
                                NODE_ARRAY_ELEMENT.setRelease(tab, i, node2);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block29;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                if (fh == h && f.key == key && (fv = f.val) != null) {
                    return fv;
                }
                added = false;
                node = f;
                synchronized (node) {
                    block30: {
                        if (NODE_ARRAY_ELEMENT.getAcquire(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node e = f;
                                while (true) {
                                    if (e.hash == h && e.key == key) {
                                        val = e.val;
                                        break block30;
                                    }
                                    Node pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        val = this.ctor.apply(key);
                                        if (pred.next != null) {
                                            throw new IllegalStateException("Recursive update");
                                        }
                                        added = true;
                                        pred.next = new Node<Object>(h, key, val);
                                        break block30;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                TreeNode p;
                                TreeBin t = (TreeBin)f;
                                binCount = 2;
                                TreeNode r = t.root;
                                if (r != null && (p = r.findTreeNode(h, key)) != null) {
                                    val = p.val;
                                } else {
                                    val = this.ctor.apply(key);
                                    added = true;
                                    t.putTreeVal(h, key, val);
                                }
                            } else if (f instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (!added) {
                return (V)val;
            }
        }
        this.addCount(1L, binCount);
        return (V)val;
    }

    public @Nullable V remove(long key) {
        return this.replaceNode(key, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final @Nullable V replaceNode(long key, @Nullable V value, @Nullable Object cv) {
        int i;
        Node f;
        int n;
        int hash = ConcurrentLongCache.spread(ConcurrentLongCache.saferHashCode(key));
        @Nullable Node[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = NODE_ARRAY_ELEMENT.getAcquire(tab, i = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node node = f;
            synchronized (node) {
                if (NODE_ARRAY_ELEMENT.getAcquire(tab, i) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node e = f;
                        Node pred = null;
                        do {
                            if (e.hash == hash && e.key == key) {
                                Object ev = e.val;
                                if (cv == null || cv == ev || cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value != null) {
                                        e.val = value;
                                    } else if (pred != null) {
                                        pred.next = e.next;
                                    } else {
                                        NODE_ARRAY_ELEMENT.set(tab, i, e.next);
                                    }
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        TreeBin t = (TreeBin)f;
                        validated = true;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(hash, key)) != null) {
                            Object pv = p.val;
                            if (cv == null || cv == pv || cv.equals(pv)) {
                                oldVal = pv;
                                if (value != null) {
                                    p.val = value;
                                } else if (t.removeTreeNode(p)) {
                                    NODE_ARRAY_ELEMENT.setRelease(tab, i, ConcurrentLongCache.untreeify(t.first));
                                }
                            }
                        }
                    } else if (f instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    @Override
    public Iterator<V> iterator() {
        @Nullable Node<V>[] t = this.table;
        int f = t == null ? 0 : t.length;
        return new ValueIterator<V>(t, f, 0, f);
    }

    static {
        try {
            MethodHandles.Lookup lookup = ReflectionUtil.getTrustedLookup();
            NODE_ARRAY_ELEMENT = MethodHandles.arrayElementVarHandle(Node[].class);
            TREEBIN_WAITERTHREAD = lookup.findVarHandle(TreeBin.class, "waiter", Thread.class);
            GET_THREAD_THREAD_LOCAL_RANDOM_PROBE = lookup.findGetter(Thread.class, "threadLocalRandomProbe", Integer.TYPE);
            THREAD_LOCAL_RANDOM_LOCAL_INIT = lookup.findStatic(ThreadLocalRandom.class, "localInit", MethodType.methodType(Void.TYPE));
            THREAD_LOCAL_RANDOM_ADVANCE_PROBE = lookup.findStatic(ThreadLocalRandom.class, "advanceProbe", MethodType.methodType(Integer.TYPE, Integer.TYPE));
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
        ReservationNode.class.getClasses();
    }

    private static class Node<V>
    implements Entry<V> {
        final int hash;
        final long key;
        volatile @UnknownNullability V val;
        volatile @Nullable Node<V> next;

        Node(int hash, long key, @UnknownNullability V val) {
            this.hash = hash;
            this.key = key;
            this.val = val;
        }

        Node(int hash, long key, @UnknownNullability V val, @Nullable Node<V> next) {
            this(hash, key, val);
            this.next = next;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        public final boolean equals(Object obj) {
            Entry entry;
            return obj instanceof Entry && (entry = (Entry)obj).getKey() == this.key && Objects.equals(entry.getValue(), this.val);
        }

        public final int hashCode() {
            return ConcurrentLongCache.saferHashCode(this.key) ^ this.val.hashCode();
        }

        @Nullable Node<V> find(int h, long k) {
            Node<V> node = this;
            do {
                if (node.hash != h || node.key != k) continue;
                return node;
            } while ((node = node.next) != null);
            return null;
        }
    }

    private static final class TreeNode<V>
    extends Node<V> {
        private @Nullable TreeNode<V> parent;
        private @Nullable TreeNode<V> left;
        private @Nullable TreeNode<V> right;
        private @Nullable TreeNode<V> prev;
        private boolean red;

        public TreeNode(int hash, long key, V val, @Nullable Node<V> next, @Nullable TreeNode<V> parent) {
            super(hash, key, val, next);
            this.parent = parent;
        }

        public final @Nullable TreeNode<V> findTreeNode(int h, long k) {
            TreeNode<V> p = this;
            do {
                TreeNode<V> pl = p.left;
                TreeNode<V> pr = p.right;
                int ph = p.hash;
                if (ph > h) {
                    p = pl;
                    continue;
                }
                if (ph < h) {
                    p = pr;
                    continue;
                }
                long pk = p.key;
                if (pk == k) {
                    return p;
                }
                if (pl == null) {
                    p = pr;
                    continue;
                }
                if (pr == null) {
                    p = pl;
                    continue;
                }
                TreeNode<V> treeNode = p = k < pk ? pl : pr;
            } while (p != null);
            return null;
        }
    }

    private static final class TreeBin<V>
    extends Node<V> {
        private static final int WRITER = 1;
        private static final int WAITER = 2;
        private static final int READER = 4;
        private @Nullable TreeNode<V> root;
        private volatile @Nullable TreeNode<V> first;
        private volatile @Nullable Thread waiter;
        private final AtomicInteger lockState = new AtomicInteger();

        TreeBin(TreeNode<V> b) {
            super(-2, Long.MIN_VALUE, null);
            this.first = b;
            TreeNode r = null;
            TreeNode x = b;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (r == null) {
                    x.parent = null;
                    x.red = false;
                    r = x;
                } else {
                    TreeNode xp;
                    int dir;
                    long k = x.key;
                    int h = x.hash;
                    TreeNode p = r;
                    do {
                        long pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else {
                            dir = Long.compare(k, pk);
                            if (dir == 0) {
                                dir = TreeBin.tieBreakOrder(k, pk);
                            }
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
            assert (TreeBin.checkInvariants(this.root));
        }

        private static int tieBreakOrder(long a, long b) {
            return System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
        }

        static <V> TreeNode<V> rotateLeft(TreeNode<V> root, @Nullable TreeNode<V> p) {
            TreeNode r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        private static <V> TreeNode<V> rotateRight(TreeNode<V> root, @Nullable TreeNode<V> p) {
            TreeNode l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        private static <V> TreeNode<V> balanceInsertion(TreeNode<V> root, TreeNode<V> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeBin.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeBin.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        private static <V> TreeNode<V> balanceDeletion(TreeNode<V> root, TreeNode<V> x) {
            while (x != null && x != root) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode xpl = xp.left;
                if (xpl == x) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        private static <V> boolean checkInvariants(TreeNode<V> t) {
            TreeNode tp = t.parent;
            TreeNode tl = t.left;
            TreeNode tr = t.right;
            TreeNode tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        private final void lockRoot() {
            if (!this.lockState.compareAndSet(0, 1)) {
                this.contendedLock();
            }
        }

        private final void unlockRoot() {
            this.lockState.set(0);
        }

        private final void contendedLock() {
            Thread current = Thread.currentThread();
            while (true) {
                int s;
                if (((s = this.lockState.get()) & 0xFFFFFFFD) == 0) {
                    if (!this.lockState.compareAndSet(s, 1)) continue;
                    if (this.waiter == current) {
                        TREEBIN_WAITERTHREAD.compareAndSet(this, current, null);
                    }
                    return;
                }
                if ((s & 2) == 0) {
                    this.lockState.compareAndSet(s, s | 2);
                    continue;
                }
                Thread w = this.waiter;
                if (w == null) {
                    TREEBIN_WAITERTHREAD.compareAndSet(this, null, current);
                    continue;
                }
                if (w != current) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable Node<V> find(int h, long k) {
            Node e = this.first;
            while (e != null) {
                TreeNode<V> p;
                int s = this.lockState.get();
                if ((s & 3) != 0) {
                    if (e.hash == h && e.key == k) {
                        return e;
                    }
                    e = e.next;
                    continue;
                }
                if (!this.lockState.compareAndSet(s, s + 4)) continue;
                try {
                    TreeNode<V> r = this.root;
                    p = r == null ? null : r.findTreeNode(h, k);
                }
                finally {
                    Thread w;
                    if (this.lockState.getAndAdd(-4) == 6 && (w = this.waiter) != null) {
                        LockSupport.unpark(w);
                    }
                }
                return p;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final @Nullable TreeNode<V> putTreeVal(int h, long k, V v) {
            block16: {
                TreeNode<V> xp;
                int dir;
                boolean searched = false;
                TreeNode<V> p = this.root;
                do {
                    if (p == null) {
                        this.root = new TreeNode<V>(h, k, v, null, null);
                        this.first = this.root;
                        break block16;
                    }
                    int ph = p.hash;
                    if (ph > h) {
                        dir = -1;
                    } else if (ph < h) {
                        dir = 1;
                    } else {
                        long pk = p.key;
                        if (pk == k) {
                            return p;
                        }
                        dir = Long.compare(k, pk);
                    }
                    xp = p;
                } while ((p = dir <= 0 ? p.left : p.right) != null);
                TreeNode<V> f = this.first;
                TreeNode<V> x = new TreeNode<V>(h, k, v, f, xp);
                this.first = x;
                if (f != null) {
                    f.prev = x;
                }
                if (dir <= 0) {
                    xp.left = x;
                } else {
                    xp.right = x;
                }
                if (!xp.red) {
                    x.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean removeTreeNode(TreeNode<V> p) {
            TreeNode rl;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<V> r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p.left;
                TreeNode pr = p.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s = pr;
                    while ((sl = s.left) != null) {
                        s = sl;
                    }
                    boolean c = s.red;
                    s.red = p.red;
                    p.red = c;
                    TreeNode sr = s.right;
                    TreeNode pp2 = p.parent;
                    if (s == pr) {
                        p.parent = s;
                        s.right = p;
                    } else {
                        TreeNode sp = s.parent;
                        p.parent = sp;
                        if (p.parent != null) {
                            if (s == sp.left) {
                                sp.left = p;
                            } else {
                                sp.right = p;
                            }
                        }
                        s.right = pr;
                        pr.parent = s;
                    }
                    p.left = null;
                    p.right = sr;
                    if (p.right != null) {
                        sr.parent = p;
                    }
                    s.left = pl;
                    pl.parent = s;
                    s.parent = pp2;
                    if (s.parent == null) {
                        r = s;
                    } else if (p == pp2.left) {
                        pp2.left = s;
                    } else {
                        pp2.right = s;
                    }
                    replacement = Objects.requireNonNullElse(sr, p);
                } else {
                    replacement = pl != null ? pl : Objects.requireNonNullElse(pr, p);
                }
                if (replacement != p) {
                    replacement.parent = p.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p.parent = null;
                    p.right = null;
                    p.left = null;
                }
                TreeNode<V> treeNode = this.root = p.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p == replacement && (pp = p.parent) != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                    p.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }
    }

    private static final class CounterCell {
        private final AtomicLong value;

        public CounterCell(long x) {
            this.value = new AtomicLong(x);
        }
    }

    private static final class ForwardingNode<V>
    extends Node<V> {
        private final @Nullable Node<V> @Nullable [] nextTable;

        public ForwardingNode(@Nullable Node<V> @Nullable [] tab) {
            super(-1, Long.MIN_VALUE, null);
            this.nextTable = tab;
        }

        @Override
        @Nullable Node<V> find(int h, long k) {
            @Nullable Node[] tab = this.nextTable;
            block0: while (true) {
                Node e;
                int n;
                if (tab == null || (n = tab.length) == 0 || (e = NODE_ARRAY_ELEMENT.getAcquire(tab, n - 1 & h)) == null) {
                    return null;
                }
                do {
                    int eh;
                    if ((eh = e.hash) == h && e.key == k) {
                        return e;
                    }
                    if (eh >= 0) continue;
                    if (e instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e).nextTable;
                        continue block0;
                    }
                    return e.find(h, k);
                } while ((e = e.next) != null);
                break;
            }
            return null;
        }
    }

    private static final class ReservationNode<V>
    extends Node<V> {
        public ReservationNode() {
            super(-3, Long.MIN_VALUE, null);
        }

        @Override
        @Nullable Node<V> find(int h, long k) {
            return null;
        }
    }

    private static final class ValueIterator<V>
    extends Traverser<V>
    implements Iterator<V> {
        public ValueIterator(@Nullable Node<V> @Nullable [] tab, int size, int index, int limit) {
            super(tab, size, index, limit);
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object v = p.val;
            this.advance();
            return v;
        }
    }

    private static class Traverser<V> {
        private @Nullable Node<V> @Nullable [] tab;
        protected @Nullable Node<V> next;
        private @Nullable TableStack<V> stack;
        private @Nullable TableStack<V> spare;
        private int index;
        private int baseIndex;
        private final int baseLimit;
        private final int baseSize;

        public Traverser(@Nullable Node<V> @Nullable [] tab, int size, int index, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = index;
            this.index = index;
            this.baseLimit = limit;
        }

        public final @Nullable Node<V> advance() {
            TreeNode e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i;
                int n;
                Node[] t;
                block11: {
                    block10: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block10;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i = this.index) && i >= 0) break block11;
                    }
                    this.next = null;
                    return null;
                }
                e = NODE_ARRAY_ELEMENT.getAcquire(t, i);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)((Object)e)).nextTable;
                        e = null;
                        this.pushState(t, i, n);
                        continue;
                    }
                    if (e instanceof TreeBin) {
                        e = ((TreeBin)((Object)e)).first;
                        continue;
                    }
                    e = null;
                    continue;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(@Nullable Node<V>[] t, int i, int n) {
            TableStack<V> s = this.spare;
            if (s != null) {
                this.spare = s.next;
            } else {
                s = new TableStack();
            }
            s.tab = t;
            s.length = n;
            s.index = i;
            s.next = this.stack;
            this.stack = s;
        }

        private void recoverState(int n) {
            int len;
            TableStack<V> s;
            while ((s = this.stack) != null && (this.index += (len = s.length)) >= n) {
                n = len;
                this.index = s.index;
                this.tab = s.tab;
                s.tab = null;
                TableStack next = s.next;
                s.next = this.spare;
                this.stack = next;
                this.spare = s;
            }
            if (s == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class TableStack<V> {
        int length;
        int index;
        @Nullable Node<V> @Nullable [] tab;
        @Nullable TableStack<V> next;

        TableStack() {
        }
    }

    public static interface Entry<V> {
        public long getKey();

        public V getValue();
    }
}

