/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.occlusion;

import de.pianoman911.playerculling.platformcommon.cache.DataProvider;
import de.pianoman911.playerculling.platformcommon.util.BlockFace;
import de.pianoman911.playerculling.platformcommon.util.NumberUtil;
import de.pianoman911.playerculling.platformcommon.vector.Vec3d;
import de.pianoman911.playerculling.platformcommon.vector.Vec3i;

public final class FacedOcclusionStepping {
    private static final int GRID_SIZE = 0x1000000;

    private static double getPos(double dir, double pos, double step) {
        return dir > 0.0 ? pos - step : step + 1.0 - pos;
    }

    public static int scanOccluded(DataProvider provider, Vec3d start, Vec3i startVoxel, double maxDistanceSqrt, double dirX, double dirY, double dirZ) {
        double thirdPosition;
        BlockFace thirdFace;
        double thirdDirection;
        double secondPosition;
        BlockFace secondFace;
        double secondDirection;
        double mainPosition;
        BlockFace mainFace;
        double mainDirection = Math.abs(dirX);
        if (Math.abs(dirY) > mainDirection) {
            mainDirection = Math.abs(dirY);
            if (Math.abs(dirZ) > mainDirection) {
                mainDirection = Math.abs(dirZ);
                mainFace = dirZ > 0.0 ? BlockFace.SOUTH : BlockFace.NORTH;
                mainPosition = FacedOcclusionStepping.getPos(dirZ, start.getZ(), startVoxel.getZ());
                secondDirection = Math.abs(dirX);
                secondFace = dirX > 0.0 ? BlockFace.EAST : BlockFace.WEST;
                secondPosition = FacedOcclusionStepping.getPos(dirX, start.getX(), startVoxel.getX());
                thirdDirection = Math.abs(dirY);
                thirdFace = dirY > 0.0 ? BlockFace.UP : BlockFace.DOWN;
                thirdPosition = FacedOcclusionStepping.getPos(dirY, start.getY(), startVoxel.getY());
            } else {
                mainFace = dirY > 0.0 ? BlockFace.UP : BlockFace.DOWN;
                mainPosition = FacedOcclusionStepping.getPos(dirY, start.getY(), startVoxel.getY());
                secondDirection = Math.abs(dirZ);
                secondFace = dirZ > 0.0 ? BlockFace.SOUTH : BlockFace.NORTH;
                secondPosition = FacedOcclusionStepping.getPos(dirZ, start.getZ(), startVoxel.getZ());
                thirdDirection = Math.abs(dirX);
                thirdFace = dirX > 0.0 ? BlockFace.EAST : BlockFace.WEST;
                thirdPosition = FacedOcclusionStepping.getPos(dirX, start.getX(), startVoxel.getX());
            }
        } else if (Math.abs(dirZ) > mainDirection) {
            mainDirection = Math.abs(dirZ);
            mainFace = dirZ > 0.0 ? BlockFace.SOUTH : BlockFace.NORTH;
            mainPosition = FacedOcclusionStepping.getPos(dirZ, start.getZ(), startVoxel.getZ());
            secondDirection = Math.abs(dirX);
            secondFace = dirX > 0.0 ? BlockFace.EAST : BlockFace.WEST;
            secondPosition = FacedOcclusionStepping.getPos(dirX, start.getX(), startVoxel.getX());
            thirdDirection = Math.abs(dirY);
            thirdFace = dirY > 0.0 ? BlockFace.UP : BlockFace.DOWN;
            thirdPosition = FacedOcclusionStepping.getPos(dirY, start.getY(), startVoxel.getY());
        } else {
            mainFace = dirX > 0.0 ? BlockFace.EAST : BlockFace.WEST;
            mainPosition = FacedOcclusionStepping.getPos(dirX, start.getX(), startVoxel.getX());
            secondDirection = Math.abs(dirY);
            secondFace = dirY > 0.0 ? BlockFace.UP : BlockFace.DOWN;
            secondPosition = FacedOcclusionStepping.getPos(dirY, start.getY(), startVoxel.getY());
            thirdDirection = Math.abs(dirZ);
            thirdFace = dirZ > 0.0 ? BlockFace.SOUTH : BlockFace.NORTH;
            thirdPosition = FacedOcclusionStepping.getPos(dirZ, start.getZ(), startVoxel.getZ());
        }
        double distance = mainPosition / mainDirection;
        long secondError = NumberUtil.floor((secondPosition - secondDirection * distance) * 1.6777216E7);
        long secondStep = NumberUtil.floor(secondDirection / mainDirection * 1.6777216E7);
        long thirdError = NumberUtil.floor((thirdPosition - thirdDirection * distance) * 1.6777216E7);
        long thirdStep = NumberUtil.floor(thirdDirection / mainDirection * 1.6777216E7);
        if (secondError + secondStep <= 0L) {
            secondError = -secondStep + 1L;
        }
        if (thirdError + thirdStep <= 0L) {
            thirdError = -thirdStep + 1L;
        }
        secondError -= 0x1000000L;
        thirdError -= 0x1000000L;
        double dirLenSqrt = mainDirection * mainDirection + secondDirection * secondDirection + thirdDirection * thirdDirection;
        int maxDistanceInt = NumberUtil.roundPositive(Math.sqrt(maxDistanceSqrt / dirLenSqrt) * mainDirection);
        int mainX = mainFace.modX;
        int mainY = mainFace.modY;
        int mainZ = mainFace.modZ;
        int mainSecondThirdX = mainX + secondFace.modX + thirdFace.modX;
        int mainSecondThirdY = mainY + secondFace.modY + thirdFace.modY;
        int mainSecondThirdZ = mainZ + secondFace.modZ + thirdFace.modZ;
        int mainSecondX = mainX + secondFace.modX;
        int mainSecondY = mainY + secondFace.modY;
        int mainSecondZ = mainZ + secondFace.modZ;
        int mainThirdX = mainX + thirdFace.modX;
        int mainThirdY = mainY + thirdFace.modY;
        int mainThirdZ = mainZ + thirdFace.modZ;
        int x0 = startVoxel.getX();
        int y0 = startVoxel.getY();
        int z0 = startVoxel.getZ();
        int currentDistance = 0;
        while (currentDistance <= maxDistanceInt) {
            ++currentDistance;
            secondError += secondStep;
            thirdError += thirdStep;
            int xC = x0 + mainX;
            int yC = y0 + mainY;
            int zC = z0 + mainZ;
            if (provider.isOpaqueFullCube(xC, yC, zC)) {
                return currentDistance;
            }
            if (secondError > 0L && thirdError > 0L) {
                x0 += mainSecondThirdX;
                y0 += mainSecondThirdY;
                z0 += mainSecondThirdZ;
                thirdError -= 0x1000000L;
                secondError -= 0x1000000L;
                continue;
            }
            if (secondError > 0L) {
                x0 += mainSecondX;
                y0 += mainSecondY;
                z0 += mainSecondZ;
                secondError -= 0x1000000L;
                continue;
            }
            if (thirdError > 0L) {
                x0 += mainThirdX;
                y0 += mainThirdY;
                z0 += mainThirdZ;
                thirdError -= 0x1000000L;
                continue;
            }
            x0 = xC;
            y0 = yC;
            z0 = zC;
        }
        return -currentDistance;
    }
}

