/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.commands.builtin;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.pianoman911.playerculling.core.commands.PlayerCullingCommand;
import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSender;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSourceStack;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class PlayerCullingHiddenCommand {
    private PlayerCullingHiddenCommand() {
    }

    public static LiteralArgumentBuilder<PlatformCommandSourceStack> getNode(CullShip ship) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)PlayerCullingCommand.literal("hidden").requires(ctx -> ctx.getExecutor() instanceof PlatformPlayer && ctx.getSender().hasPermission("playerculling.command.hidden"))).executes(ctx -> PlayerCullingHiddenCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (PlatformPlayer)((PlatformCommandSourceStack)ctx.getSource()).getExecutor(), ship));
    }

    private static int execute(PlatformCommandSender sender, PlatformPlayer executor, CullShip ship) {
        CullPlayer cullPlayer = ship.getPlayer(executor.getUniqueId());
        if (cullPlayer == null) {
            sender.sendMessage((Component)Component.text((String)(executor == sender ? "You are not culling." : executor.getName() + " is not a culling player."), (TextColor)NamedTextColor.RED));
            return 0;
        }
        Set<UUID> hidden = cullPlayer.getHidden();
        HashSet<String> names = new HashSet<String>(hidden.size());
        for (UUID uuid : hidden) {
            PlatformPlayer player = ship.getPlatform().getPlayer(uuid);
            names.add(player.getName());
        }
        if (names.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)(executor == sender ? "You see all players." : executor.getName() + " sees all players."), (TextColor)NamedTextColor.GREEN));
            return 1;
        }
        sender.sendMessage(Component.text((String)(executor == sender ? "You are hiding: " : executor.getName() + " is hiding: ")).append((Component)Component.text((String)String.join((CharSequence)", ", names), (TextColor)NamedTextColor.GREEN)));
        return 1;
    }
}

