/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.commands.builtin;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.pianoman911.playerculling.core.commands.PlayerCullingCommand;
import de.pianoman911.playerculling.platformcommon.cache.OcclusionChunkCache;
import de.pianoman911.playerculling.platformcommon.cache.OcclusionWorldCache;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSender;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSourceStack;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformEntity;
import de.pianoman911.playerculling.platformcommon.util.StringUtil;
import java.util.ArrayList;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class PlayerCullingChunkSizesCommand {
    private PlayerCullingChunkSizesCommand() {
    }

    public static LiteralArgumentBuilder<PlatformCommandSourceStack> getNode() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)PlayerCullingCommand.literal("chunksizes").requires(ctx -> ctx.getExecutor() != null && ctx.getSender().hasPermission("playerculling.command.chunksizes"))).executes(ctx -> PlayerCullingChunkSizesCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), Objects.requireNonNull(((PlatformCommandSourceStack)ctx.getSource()).getExecutor())));
    }

    private static int execute(PlatformCommandSender sender, PlatformEntity executor) {
        OcclusionWorldCache world = executor.getWorld().getOcclusionWorldCache();
        sender.sendMessage(Component.text((String)"All Chunk bytes: ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)StringUtil.toNumInUnits(world.bytes()))));
        ArrayList<OcclusionChunkCache> chunks = new ArrayList<OcclusionChunkCache>();
        for (OcclusionChunkCache chunk : world.getChunkCache()) {
            chunks.add(chunk);
        }
        chunks.sort((o1, o2) -> Long.compare(o2.byteSize(), o1.byteSize()));
        for (OcclusionChunkCache chunk : chunks) {
            sender.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Chunk ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((int)chunk.getX(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)", ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)chunk.getZ(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)StringUtil.toNumInUnits(chunk.byteSize()), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" bytes", (TextColor)NamedTextColor.GREEN))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to Teleport")))).clickEvent(ClickEvent.callback(audience -> {
                if (sender instanceof PlatformEntity) {
                    PlatformEntity entity = (PlatformEntity)sender;
                    entity.teleport(entity.getWorld(), chunk.getX() * 16 + 8, entity.getPosition().getY(), chunk.getZ() * 16 + 8);
                }
            })));
        }
        return 1;
    }
}

