/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformArgument;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSourceStack;
import de.pianoman911.playerculling.platformcommon.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;

public class CommandConversionHandler<P> {
    private static final MethodHandle ARGUMENT_GETTER = ReflectionUtil.getGetter(CommandContext.class, Map.class, 1);
    private final Function<PlatformCommandSourceStack, P> converter;
    private final Function<P, PlatformCommandSourceStack> reverseConverter;
    private final @Nullable UnaryOperator<ArgumentType<?>> argumentWrapper;
    private final @Nullable UnaryOperator<ArgumentType<?>> argumentUnwrapper;

    public CommandConversionHandler(Function<PlatformCommandSourceStack, P> converter, Function<P, PlatformCommandSourceStack> reverseConverter, @Nullable UnaryOperator<ArgumentType<?>> argumentWrapper, @Nullable UnaryOperator<ArgumentType<?>> argumentUnwrapper) {
        this.converter = converter;
        this.reverseConverter = reverseConverter;
        this.argumentWrapper = argumentWrapper;
        this.argumentUnwrapper = argumentUnwrapper;
    }

    private <T, F> T convertCss(F css) {
        if (css instanceof PlatformCommandSourceStack) {
            PlatformCommandSourceStack internal = (PlatformCommandSourceStack)css;
            return (T)this.converter.apply(internal);
        }
        return (T)this.reverseConverter.apply(css);
    }

    private <T, F> Map<String, ParsedArgument<T, ?>> convertArguments(Map<String, ParsedArgument<F, ?>> arguments, Map<String, ArgumentType<?>> argumentTypes) throws CommandSyntaxException {
        HashMap converted = new HashMap(arguments.size());
        for (Map.Entry<String, ParsedArgument<F, ?>> entry : arguments.entrySet()) {
            Object result;
            String name = entry.getKey();
            ParsedArgument<F, ?> value = entry.getValue();
            ArgumentType<?> type = argumentTypes.get(name);
            if (type instanceof PlatformArgument) {
                PlatformArgument arg = (PlatformArgument)type;
                result = arg.convertToPlatform(value.getResult());
            } else {
                result = value.getResult();
            }
            ParsedArgument convertedValue = new ParsedArgument(value.getRange().getStart(), value.getRange().getEnd(), result);
            converted.put(name, convertedValue);
        }
        return converted;
    }

    private <T, F> CommandContext<T> convertCtx(CommandContext<F> ctx) throws CommandSyntaxException {
        Map arguments;
        if (ctx == null) {
            return null;
        }
        try {
            arguments = ARGUMENT_GETTER.invoke(ctx);
        }
        catch (Throwable exception) {
            throw new RuntimeException(exception);
        }
        List nodes = ctx.getNodes();
        HashMap argumentTypes = new HashMap(nodes.size());
        for (ParsedCommandNode node : nodes) {
            CommandNode commandNode = node.getNode();
            if (!(commandNode instanceof ArgumentCommandNode)) continue;
            ArgumentCommandNode argNode = (ArgumentCommandNode)commandNode;
            ArgumentType argType = this.argumentWrapper == null ? argNode.getType() : (ArgumentType)this.argumentWrapper.apply(argNode.getType());
            argumentTypes.put(argNode.getName(), argType);
        }
        return new CommandContext(this.convertCss(ctx.getSource()), ctx.getInput(), this.convertArguments(arguments, argumentTypes), this.remapCommand((CommandNode)ctx.getCommand()), null, this.convertNodes(ctx.getNodes()), ctx.getRange(), this.convertCtx(ctx.getChild()), null, ctx.isForked());
    }

    private <T, F> List<ParsedCommandNode<T>> convertNodes(List<ParsedCommandNode<F>> nodes) {
        ArrayList<ParsedCommandNode<T>> converted = new ArrayList<ParsedCommandNode<T>>(nodes.size());
        for (ParsedCommandNode<F> node : nodes) {
            converted.add(new ParsedCommandNode(this.remapCommand(node.getNode()), node.getRange()));
        }
        return converted;
    }

    private <T, F> Command<T> remapCommand(Command<F> command) {
        return ctx -> {
            CommandContext stack = this.convertCtx(ctx);
            return command.run(stack);
        };
    }

    private <T, F> ArgumentBuilder<T, ?> createArgumentBuilder(ArgumentCommandNode<F, ?> node) {
        ArgumentType argumentType = this.argumentUnwrapper != null ? (ArgumentType)this.argumentUnwrapper.apply(node.getType()) : node.getType();
        RequiredArgumentBuilder argument = RequiredArgumentBuilder.argument((String)node.getName(), (ArgumentType)argumentType);
        if (node.getCustomSuggestions() == null) {
            return argument;
        }
        argument.suggests((ctx, builder) -> {
            CommandContext other = this.convertCtx(ctx);
            return node.getCustomSuggestions().getSuggestions(other, builder);
        });
        return argument;
    }

    private <T, F> ArgumentBuilder<T, ?> createLiteralBuilder(LiteralCommandNode<F> node) {
        return LiteralArgumentBuilder.literal((String)node.getName());
    }

    private <T, F> ArgumentBuilder<T, ?> createRootBuilder(RootCommandNode<F> node) {
        return LiteralArgumentBuilder.literal((String)node.getName());
    }

    public <I extends CommandNode<F>, O extends CommandNode<T>, T, F> O remapCommand(I node) {
        CommandNode redirect;
        Command command;
        I i = node;
        Objects.requireNonNull(i);
        I i2 = i;
        int n = 0;
        ArgumentBuilder<T, ?> builder = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LiteralCommandNode.class, ArgumentCommandNode.class, RootCommandNode.class}, i2, n)) {
            case 0 -> {
                LiteralCommandNode lnode = (LiteralCommandNode)i2;
                yield this.createLiteralBuilder(lnode);
            }
            case 1 -> {
                ArgumentCommandNode anode = (ArgumentCommandNode)i2;
                yield this.createArgumentBuilder(anode);
            }
            case 2 -> {
                RootCommandNode rnode = (RootCommandNode)i2;
                yield this.createRootBuilder(rnode);
            }
            default -> throw new UnsupportedOperationException("Unsupported command node type: " + String.valueOf(node.getClass()));
        };
        Predicate requirement = node.getRequirement();
        if (requirement != null) {
            builder.requires(css -> requirement.test(this.convertCss(css)));
        }
        if ((command = node.getCommand()) != null) {
            builder.executes(this.remapCommand((I)node.getCommand()));
        }
        if ((redirect = node.getRedirect()) != null) {
            builder.redirect(this.remapCommand(redirect));
        }
        for (CommandNode child : node.getChildren()) {
            builder.then(this.remapCommand(child));
        }
        return (O)builder.build();
    }
}

