/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformcommon.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import sun.misc.Unsafe;

public final class ReflectionUtil {
    private static final Unsafe THE_UNSAFE;
    private static final MethodHandles.Lookup TRUSTED_LOOKUP;

    public static MethodHandles.Lookup getTrustedLookup() {
        return TRUSTED_LOOKUP;
    }

    public static MethodHandle getGetter(Class<?> clazz, Class<?> type, int offset) {
        return ReflectionUtil.getGetter(ReflectionUtil.lookupField(clazz, type, offset));
    }

    public static MethodHandle getGetter(Field field) {
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                return TRUSTED_LOOKUP.findStaticGetter(field.getDeclaringClass(), field.getName(), field.getType());
            }
            return TRUSTED_LOOKUP.findGetter(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static MethodHandle getSetter(Class<?> clazz, Class<?> type, int offset) {
        return ReflectionUtil.getSetter(ReflectionUtil.lookupField(clazz, type, offset));
    }

    public static MethodHandle getSetter(Field field) {
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                return TRUSTED_LOOKUP.findStaticSetter(field.getDeclaringClass(), field.getName(), field.getType());
            }
            return TRUSTED_LOOKUP.findSetter(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Field lookupField(Class<?> clazz, Class<?> type, int offset) {
        int i = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type || i++ != offset) continue;
            return field;
        }
        throw new IllegalArgumentException("Can't find field " + String.valueOf(type) + " with offset " + offset + " in " + clazz.getName());
    }

    static {
        Unsafe unsafe = null;
        for (Field field : Unsafe.class.getDeclaredFields()) {
            if (field.getType() != Unsafe.class) continue;
            try {
                field.trySetAccessible();
                unsafe = (Unsafe)field.get(null);
                break;
            }
            catch (ReflectiveOperationException exception) {
                throw new RuntimeException(exception);
            }
        }
        THE_UNSAFE = Objects.requireNonNull(unsafe, "Can't find unsafe instance");
        try {
            MethodHandles.lookup();
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long implLookupFieldOffset = THE_UNSAFE.staticFieldOffset(implLookupField);
            TRUSTED_LOOKUP = (MethodHandles.Lookup)THE_UNSAFE.getObject(MethodHandles.Lookup.class, implLookupFieldOffset);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }
}

