/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformcommon.cache;

import de.pianoman911.playerculling.platformcommon.cache.OcclusionWorldCache;
import de.pianoman911.playerculling.platformcommon.platform.world.PlatformChunkAccess;
import de.pianoman911.playerculling.platformcommon.util.OcclusionMappings;
import java.lang.ref.WeakReference;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public final class OcclusionChunkCache {
    public static final int VOXEL_LENGTH = 8;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PlayerCulling");
    private static final int MAX_CHUNK_COMPUTE_DEPTH = 5;
    private final OcclusionWorldCache world;
    public final int x;
    public final int z;
    private volatile long @MonotonicNonNull [] occlusionData = null;
    private volatile int minY;
    private volatile int minYX2;
    private volatile int maxY;
    private volatile int height;
    private volatile int heightX2;
    private volatile boolean fullyComputed = false;
    private volatile boolean computing = false;
    private @Nullable WeakReference<PlatformChunkAccess> chunk;

    public OcclusionChunkCache(OcclusionWorldCache world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
        this.minY = world.getWorld().getMinY();
        this.minYX2 = this.minY * 2;
        this.maxY = world.getWorld().getMaxY();
        this.height = this.maxY - this.minY + 1;
        this.heightX2 = this.height * 2;
        this.resolveChunkAccess();
    }

    public static void set(long[] data, int index, boolean occludes) {
        int i = index >>> 6;
        int j = index & 0x3F;
        if (occludes) {
            int n = i;
            data[n] = data[n] | 1L << j;
        } else {
            int n = i;
            data[n] = data[n] & (1L << j ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static int index(int x, int y, int z) {
        return x | z << 5 | y << 10;
    }

    private @Nullable PlatformChunkAccess resolveChunkAccess() {
        PlatformChunkAccess chunk;
        PlatformChunkAccess platformChunkAccess = chunk = this.chunk != null ? (PlatformChunkAccess)this.chunk.get() : null;
        if (chunk == null) {
            chunk = this.world.getWorld().getChunkAccess(this.x, this.z);
            if (chunk == null) {
                return null;
            }
            this.chunk = new WeakReference<PlatformChunkAccess>(chunk);
            this.computeFully(chunk);
        }
        return chunk;
    }

    private final int doubleDoubleIndex(double x, double y, double z) {
        int ix = (int)(x * 2.0);
        int iy = (int)(y * 2.0);
        int iz = (int)(z * 2.0);
        return OcclusionChunkCache.index(ix, iy, iz);
    }

    public final boolean isOccluded(int index) {
        return (this.occlusionData[index >>> 6] & 1L << (index & 0x3F)) != 0L;
    }

    public final boolean isOccluded(double x, double y, double z) {
        if ((y -= (double)this.minY) < 0.0 || y >= (double)this.height) {
            return false;
        }
        int relX = Math.floorMod((int)(x * 2.0), 32);
        int relZ = Math.floorMod((int)(z * 2.0), 32);
        if (this.fullyComputed) {
            int index = OcclusionChunkCache.index(relX, (int)(y * 2.0), relZ);
            return this.isOccluded(index);
        }
        PlatformChunkAccess chunk = this.resolveChunkAccess();
        if (chunk == null) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (!chunk.isOpaque(relX >> 1, (int)y + this.minY, relZ >> 1, i)) continue;
            return true;
        }
        return false;
    }

    public final boolean isVoxelOccluded(int x, int y, int z) {
        if ((y -= this.minYX2) < 0 || y >= this.heightX2) {
            return false;
        }
        if (this.fullyComputed) {
            return this.isOccluded(OcclusionChunkCache.index(x & 0x1F, y, z & 0x1F));
        }
        return this.isOccluded((double)x / 2.0, (double)(y + this.minYX2) / 2.0, (double)z / 2.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeFully(@Nullable PlatformChunkAccess access) {
        OcclusionChunkCache occlusionChunkCache = this;
        synchronized (occlusionChunkCache) {
            if (access == null || this.fullyComputed || this.computing) {
                return;
            }
            this.computing = true;
        }
        OcclusionWorldCache.CACHE_EXECUTOR.execute(() -> this.computeFully0(access, 0));
    }

    private void computeFully0(PlatformChunkAccess access, int depth) {
        if (depth > 5) {
            LOGGER.warn("Failed to compute occlusion data for chunk at {}, {} after 5 retries", (Object)this.x, (Object)this.z);
            this.computing = false;
            return;
        }
        try {
            int bottomY = this.height;
            int topY = 0;
            long[] data = new long[this.height * 4 * 8];
            for (int cy = 0; cy < this.height; ++cy) {
                int y = cy + this.minY;
                for (int cx = 0; cx < 16; ++cx) {
                    for (int cz = 0; cz < 16; ++cz) {
                        for (int i = 0; i < 8; ++i) {
                            boolean opaque = access.isOpaque(cx, y, cz, i);
                            if (!opaque) continue;
                            bottomY = Math.min(bottomY, y);
                            topY = Math.max(topY, y);
                            double offX = (double)(i & 1) * 0.5;
                            double offY = (double)(i >> 1 & 1) * 0.5;
                            double offZ = (double)(i >> 2 & 1) * 0.5;
                            OcclusionChunkCache.set(data, this.doubleDoubleIndex((double)cx + offX, (double)cy + offY, (double)cz + offZ), true);
                        }
                    }
                }
            }
            int height = topY - bottomY + 1;
            if (height != this.height) {
                long[] minifiedData = new long[height * 4 * 8];
                System.arraycopy(data, (bottomY - this.minY) * 4 * 8, minifiedData, 0, height * 4 * 8);
                this.occlusionData = minifiedData;
            } else {
                this.occlusionData = data;
            }
            this.minY = bottomY;
            this.minYX2 = bottomY * 2;
            this.maxY = topY;
            this.height = height;
            this.heightX2 = height * 2;
            this.fullyComputed = true;
            this.computing = false;
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to compute occlusion data for chunk at {} {}", new Object[]{this.x, this.z, throwable});
            this.computeFully0(access, depth + 1);
        }
    }

    public void recalculateBlock(int x, int y, int z) {
        PlatformChunkAccess chunk;
        if (!this.fullyComputed) {
            return;
        }
        x &= 0xF;
        z &= 0xF;
        if ((y -= this.minY) < 0 || y >= this.height) {
            int prevMin = this.minY;
            int prevMax = this.maxY;
            this.minY = Math.min(prevMin, y + prevMin);
            this.maxY = Math.max(prevMax, y + prevMin);
            int height = this.maxY - this.minY + 1;
            long[] data = new long[height * 4 * 8];
            System.arraycopy(this.occlusionData, (prevMin - this.minY) * 4 * 8, data, (prevMin - this.minY) * 4 * 8, (prevMax - prevMin + 1) * 4 * 8);
            this.occlusionData = data;
            this.height = height;
            this.heightX2 = height * 2;
            this.minYX2 = this.minY * 2;
        }
        if ((chunk = this.resolveChunkAccess()) == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            boolean opaque = chunk.isOpaque(x, y + this.minY, z, i);
            double ix = (double)x + (double)(i & 1) * 0.5;
            double iy = (double)y + (double)(i >> 1 & 1) * 0.5;
            double iz = (double)z + (double)(i >> 2 & 1) * 0.5;
            OcclusionChunkCache.set(this.occlusionData, this.doubleDoubleIndex(ix, iy, iz), opaque);
        }
    }

    public OcclusionWorldCache getWorld() {
        return this.world;
    }

    final long[] getOcclusionData() {
        return this.occlusionData;
    }

    public final int getX() {
        return this.x;
    }

    public final int getZ() {
        return this.z;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    public boolean isFullyComputed() {
        return this.fullyComputed;
    }

    public final boolean[] isOpaqueFullBlock(int x, int y, int z) {
        boolean[] shapes = new boolean[8];
        PlatformChunkAccess chunk = this.resolveChunkAccess();
        if (chunk == null) {
            return OcclusionMappings.EMPTY_CUBE;
        }
        for (int i = 0; i < shapes.length; ++i) {
            shapes[i] = chunk.isOpaque(x, y, z, i);
        }
        return shapes;
    }

    public final int byteSize() {
        int size = 21;
        if (this.occlusionData != null) {
            size += this.occlusionData.length * 8;
        }
        return size;
    }
}

