/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.commands.builtin;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import de.pianoman911.playerculling.core.commands.PlayerCullingCommand;
import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.core.occlusion.OcclusionCullingInstance;
import de.pianoman911.playerculling.core.util.CameraMode;
import de.pianoman911.playerculling.core.util.ClientsideUtil;
import de.pianoman911.playerculling.platformcommon.AABB;
import de.pianoman911.playerculling.platformcommon.cache.DataProvider;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSender;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSourceStack;
import de.pianoman911.playerculling.platformcommon.platform.command.SinglePlayerResolver;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import de.pianoman911.playerculling.platformcommon.platform.world.PlatformWorld;
import de.pianoman911.playerculling.platformcommon.util.DebugUtil;
import de.pianoman911.playerculling.platformcommon.vector.Vec3d;
import java.awt.Color;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class PlayerCullingRayCastDebugCommand {
    private PlayerCullingRayCastDebugCommand() {
    }

    public static LiteralArgumentBuilder<PlatformCommandSourceStack> getNode(CullShip ship) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)PlayerCullingCommand.literal("raycastdebug").requires(ctx -> ctx.getExecutor() instanceof PlatformPlayer && ctx.getSender().hasPermission("playerculling.command.raycastdebug"))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)PlayerCullingCommand.argument("target", ship.getPlatform().getArgumentProvider().player()).executes(ctx -> PlayerCullingRayCastDebugCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (PlatformPlayer)((PlatformCommandSourceStack)ctx.getSource()).getExecutor(), ship, false, false, (PlatformPlayer)((SinglePlayerResolver)ctx.getArgument("target", SinglePlayerResolver.class)).resolve((PlatformCommandSourceStack)ctx.getSource())))).then(PlayerCullingCommand.argument("showRay", BoolArgumentType.bool()).executes(ctx -> PlayerCullingRayCastDebugCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (PlatformPlayer)((PlatformCommandSourceStack)ctx.getSource()).getExecutor(), ship, (Boolean)ctx.getArgument("showRay", Boolean.class), false, (PlatformPlayer)((SinglePlayerResolver)ctx.getArgument("target", SinglePlayerResolver.class)).resolve((PlatformCommandSourceStack)ctx.getSource()))))).then(((RequiredArgumentBuilder)PlayerCullingCommand.argument("blocks", BoolArgumentType.bool()).executes(ctx -> PlayerCullingRayCastDebugCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (PlatformPlayer)((PlatformCommandSourceStack)ctx.getSource()).getExecutor(), ship, false, (Boolean)ctx.getArgument("blocks", Boolean.class), (PlatformPlayer)((SinglePlayerResolver)ctx.getArgument("target", SinglePlayerResolver.class)).resolve((PlatformCommandSourceStack)ctx.getSource())))).then(PlayerCullingCommand.argument("showRay", BoolArgumentType.bool()).executes(ctx -> PlayerCullingRayCastDebugCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), (PlatformPlayer)((PlatformCommandSourceStack)ctx.getSource()).getExecutor(), ship, (Boolean)ctx.getArgument("showRay", Boolean.class), (Boolean)ctx.getArgument("blocks", Boolean.class), (PlatformPlayer)((SinglePlayerResolver)ctx.getArgument("target", SinglePlayerResolver.class)).resolve((PlatformCommandSourceStack)ctx.getSource()))))));
    }

    public static int execute(PlatformCommandSender sender, PlatformPlayer executor, CullShip ship, boolean showRay, boolean blocks, PlatformPlayer target) {
        CullPlayer cullPlayer = ship.getPlayer(executor.getUniqueId());
        PlatformPlayer platformPlayer = cullPlayer.getPlatformPlayer();
        DebuggingDataProviderChunk provider = new DebuggingDataProviderChunk(cullPlayer, sender, showRay, blocks);
        OcclusionCullingInstance instance = new OcclusionCullingInstance(provider, 0.5);
        if (!target.getWorld().equals(executor.getWorld())) {
            sender.sendMessage((Component)Component.text((String)"Target is not in the same world", (TextColor)NamedTextColor.RED));
            return 0;
        }
        provider.world(executor.getWorld());
        AABB trackedBox = target.getBoundingBox();
        DebugUtil.drawBoundingBox(executor.getWorld(), trackedBox, Color.ORANGE);
        executor.getWorld().spawnColoredParticle(executor.getEyePosition(), Color.CYAN, 0.5f);
        Vec3d centerBox = trackedBox.getCenter().mul(2.0);
        Vec3d dir = executor.getDirection();
        Vec3d aabbMin = trackedBox.getMin().mul(2.0);
        Vec3d aabbMax = trackedBox.getMax().mul(2.0);
        Vec3d eye = new Vec3d(executor.getEyePosition().getX(), executor.getEyePosition().getY(), executor.getEyePosition().getZ());
        Vec3d viewerPosition = new Vec3d();
        Vec3d viewerBack = new Vec3d();
        Vec3d viewerFront = new Vec3d();
        viewerPosition.set(eye.getX(), eye.getY(), eye.getZ());
        viewerPosition.mul(2.0);
        boolean visible = instance.isAABBVisible(aabbMin, aabbMax, viewerPosition);
        boolean angle = CullPlayer.isInnerAngle(centerBox, viewerPosition, dir);
        double a = Math.toDegrees(CullPlayer.angle(centerBox, viewerPosition, dir));
        sender.sendMessage((Component)Component.text((String)("FirstPerson Visible: " + visible + " Angle(" + a + "): " + angle + " -> " + (visible && angle))));
        viewerBack.set(eye.getX(), eye.getY(), eye.getZ());
        ClientsideUtil.addPlayerViewOffset(viewerBack, platformPlayer, CameraMode.THIRD_PERSON_BACK);
        viewerBack.mul(2.0);
        visible = instance.isAABBVisible(aabbMin, aabbMax, viewerBack);
        angle = CullPlayer.isInnerAngle(centerBox, viewerBack, dir);
        a = Math.toDegrees(CullPlayer.angle(centerBox, viewerBack, dir));
        sender.sendMessage((Component)Component.text((String)("ThirdPersonBack Visible: " + visible + " Angle(" + a + "): " + angle + " -> " + (visible && angle))));
        viewerFront.set(eye.getX(), eye.getY(), eye.getZ());
        ClientsideUtil.addPlayerViewOffset(viewerFront, platformPlayer, CameraMode.THIRD_PERSON_FRONT);
        viewerFront.mul(2.0);
        visible = instance.isAABBVisible(aabbMin, aabbMax, viewerFront);
        angle = CullPlayer.isInnerAngle(centerBox, viewerFront, dir.mul(-1.0));
        a = Math.toDegrees(CullPlayer.angle(centerBox, viewerFront, dir));
        sender.sendMessage((Component)Component.text((String)("ThirdPersonFront Visible: " + visible + " Angle(" + a + "): " + angle + " -> " + (visible && angle))));
        return 1;
    }

    public static class DebuggingDataProviderChunk
    implements DataProvider {
        private final DataProvider delegate;
        private final CullPlayer player;
        private final PlatformCommandSender sender;
        private final boolean blocks;
        private final boolean showRays;

        private DebuggingDataProviderChunk(CullPlayer player, PlatformCommandSender sender, boolean showRays, boolean blocks) {
            this.delegate = player.getProvider();
            this.player = player;
            this.sender = sender;
            this.showRays = showRays;
            this.blocks = blocks;
        }

        @Override
        public boolean isOpaqueFullCube(int x, int y, int z) {
            boolean occluded = this.delegate.isOpaqueFullCube(x, y, z);
            Vec3d pos = new Vec3d((double)x / 2.0, (double)y / 2.0, (double)z / 2.0).add(0.25, 0.25, 0.25);
            if (this.showRays) {
                this.player.getPlatformPlayer().getWorld().spawnColoredParticle(pos, occluded ? Color.RED : Color.GREEN, 0.5f);
            }
            if (this.blocks) {
                String state = this.player.getPlatformPlayer().getWorld().getBlockStateStringOfBlock(pos.toVec3iFloored());
                this.sender.sendMessage((Component)Component.text((String)("Block: " + state + "at " + String.valueOf(pos) + " -> " + occluded)));
            }
            return occluded;
        }

        @Override
        public void world(PlatformWorld world) {
            this.delegate.world(world);
        }

        @Override
        public int getPlayerViewDistance() {
            return this.delegate.getPlayerViewDistance();
        }
    }
}

